/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Event;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.ResourcePropertySource;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class EventPropertySource
implements IPropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(EventPropertySource.class.getPackage().getName());
    private IPropertyDescriptor[] propertyDescriptors;
    private Event event;
    private Map values = new HashMap();
    protected HashMap<String, List<IPropertyDescriptor>> collectionID2Props = new HashMap();
    private static final String ARCHIVE_DATE = "ARCHIVE_DATE";
    private static final String APPLID = "APPLID";
    private static final String BUNDLE_BASESCOPE = "BUNDLE_BASESCOPE";
    private static final String BUNDLE_DIR = "BUNDLE_DIR";
    private static final String BUNDLE_CHG_AGEND = "BUNDLE_CHG_AGEND";
    private static final String BUNDLE_CHG_AGREL = "BUNDLE_CHG_AGREL";
    private static final String BUNDLE_CHG_TIME = "BUNDLE_CHG_TIME";
    private static final String BUNDLE_CHG_USERID = "BUNDLE_CHG_USERID";
    private static final String BUNDLE_DEF_SOURCE = "BUNDLE_DEF_SOURCE";
    private static final String BUNDLE_DEF_TIME = "BUNDLE_DEF_TIME";
    private static final String BUNDLE_ENA_COUNT = "BUNDLE_ENA_COUNT";
    private static final String BUNDLE_ENA_STATUS = "BUNDLE_ENA_STATUS";
    private static final String BUNDLE_INST_AGENT = "BUNDLE_INST_AGENT";
    private static final String BUNDLE_INST_TIME = "BUNDLE_INST_TIME";
    private static final String BUNDLE_INST_USERID = "BUNDLE_INST_USERID";
    private static final String BUNDLE_PART_COUNT = "BUNDLE_PART_COUNT";
    private static final String BUNDLE_TARGET_COUNT = "BUNDLE_TARGET_COUNT";
    private static final String CAPTURE_SPEC = "CAPTURE_SPEC";
    private static final String COLLECTION_ID = "COLLECTION_ID";
    private static final String EVENT_BINDING = "EVENT_BINDING";
    private static final String EVENT_NAME = "EVENT_NAME";
    private static final String EVENT_STRUCID = "EVENT_STRUCID";
    private static final String EVENT_TYPE = "EVENT_TYPE";
    private static final String EVENT_USERTAG = "EVENT_USERTAG";
    private static final String EVENT_VERSION = "EVENT_VERSION";
    private static final String EB_DEF_SOURCE = "EB_DEF_SOURCE";
    private static final String EB_DEF_TIME = "EB_DEF_TIME";
    private static final String EB_STATUS = "EB_STATUS";
    private static final String EB_ADAPTER = "EB_ADAPTER";
    private static final String EB_CHG_AGENT = "EB_CHG_AGENT";
    private static final String EB_CHG_REL = "EB_CHG_REL";
    private static final String EB_CHG_TIME = "EB_CHG_TIME";
    private static final String EB_CHG_USERID = "EB_CHG_USERID";
    private static final String EB_INST_AGENT = "EB_INST_AGENT";
    private static final String EB_INST_TIME = "EB_INST_TIME";
    private static final String EB_INST_USERID = "EB_INST_USERID";
    private static final String FIRST_RUN = "FIRST_RUN";
    private static final String HOMESYSID = "HOMESYSID";
    private static final String SCHEMA_VER = "SCHEMA_VER";
    private static final String SCHEMA_REL = "SCHEMA_REL";
    private static final String LAST_RUN = "LAST_RUN";
    private static String APPL_NAME = "APPL_NAME";
    private static String APPL_VER1 = "APPL_VER1";
    private static String APPL_VER2 = "APPL_VER2";
    private static String APPL_VER3 = "APPL_VER3";
    private static String APPL_OPER = "APPL_OPER";
    private static String PLATFORM = "PLATFORM";
    private static final String[] ia32propertyIDs = new String[]{"COLLECTION_ID", "ARCHIVE_DATE", "APPLID", "HOMESYSID", "EVENT_NAME", "CAPTURE_SPEC", "EVENT_BINDING", "EVENT_TYPE", "EVENT_STRUCID", "EVENT_VERSION", "SCHEMA_VER", "SCHEMA_REL", "EVENT_USERTAG", "EB_DEF_SOURCE", "EB_DEF_TIME", "EB_STATUS", "EB_ADAPTER", "EB_CHG_AGENT", "EB_CHG_TIME", "EB_CHG_USERID", "EB_INST_AGENT", "EB_INST_TIME", "EB_INST_USERID", "BUNDLE_BASESCOPE", "BUNDLE_DIR", "BUNDLE_CHG_AGEND", "BUNDLE_CHG_AGREL", "BUNDLE_CHG_TIME", "BUNDLE_CHG_USERID", "BUNDLE_DEF_SOURCE", "BUNDLE_DEF_TIME", "BUNDLE_ENA_COUNT", "BUNDLE_ENA_STATUS", "BUNDLE_INST_AGENT", "BUNDLE_INST_TIME", "BUNDLE_INST_USERID", "BUNDLE_PART_COUNT", "BUNDLE_TARGET_COUNT", "FIRST_RUN", "LAST_RUN"};
    private static final String[] ia51propertyIDs = IAUtilities.concat(ia32propertyIDs, new String[][]{{APPL_NAME, APPL_VER1, APPL_VER2, APPL_VER3, APPL_OPER}});
    private static final String[] ia52propertyIDs = IAUtilities.concat(ia51propertyIDs, new String[][]{{PLATFORM}});

    public EventPropertySource(Event event) {
        this.event = event;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Debug.enter((Logger)logger, (String)EventPropertySource.class.getName(), (String)"getPropertyDescriptors", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.propertyDescriptors == null) {
            List properties = this.event.getProperties();
            this.processProperties(properties);
        }
        Debug.exit((Logger)logger, (String)EventPropertySource.class.getName(), (String)"getPropertyDescriptors");
        return this.getPropertiesInCurrentCollectionId();
    }

    protected IPropertyDescriptor[] getPropertiesInCurrentCollectionId() {
        Debug.enter((Logger)logger, (String)ResourcePropertySource.class.getName(), (String)"getPropertiesInCurrentCollectionId", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (IASQLCommand.getCollectionId().isEmpty()) {
            this.initAllProperties();
            Debug.exit((Logger)logger, (String)ResourcePropertySource.class.getName(), (String)"getPropertiesInCurrentCollectionId");
            return this.propertyDescriptors;
        }
        ArrayList descriptors = new ArrayList();
        if (this.collectionID2Props.containsKey(IASQLCommand.getCollectionId())) {
            descriptors.addAll(this.collectionID2Props.get(IASQLCommand.getCollectionId()));
        }
        Debug.exit((Logger)logger, (String)ResourcePropertySource.class.getName(), (String)"getPropertiesInCurrentCollectionId");
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    protected void initAllProperties() {
        Debug.enter((Logger)logger, (String)ResourcePropertySource.class.getName(), (String)"initAllProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ArrayList<IPropertyDescriptor> descriptors = new ArrayList<IPropertyDescriptor>();
        for (List<IPropertyDescriptor> list : this.collectionID2Props.values()) {
            descriptors.addAll(list);
        }
        this.propertyDescriptors = descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
        Debug.exit((Logger)logger, (String)ResourcePropertySource.class.getName(), (String)"initAllProperties");
    }

    private void processProperties(List properties) {
        Debug.enter((Logger)logger, (String)EventPropertySource.class.getName(), (String)"processProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String[] propertyIds = EventPropertySource.getPropertyIDs();
        List<IPropertyDescriptor> descriptors = null;
        int i = 0;
        while (i < properties.size()) {
            String categoryName;
            Map rowAttrsToValues = (Map)properties.get(i);
            descriptors = this.collectionID2Props.get((String)rowAttrsToValues.get(COLLECTION_ID));
            if (descriptors == null) {
                descriptors = new ArrayList<IPropertyDescriptor>();
                this.collectionID2Props.put((String)rowAttrsToValues.get(COLLECTION_ID), descriptors);
            }
            int version = Version.getInstance().getDBVersion();
            switch (version) {
                case 3200: {
                    String string = MessageFormat.format(Messages.getString("EventPropertySource.3200"), (String)rowAttrsToValues.get(EVENT_NAME), (String)rowAttrsToValues.get(COLLECTION_ID), (String)rowAttrsToValues.get(APPLID));
                }
                case 5100: 
                case 5110: {
                    String ver1 = (String)rowAttrsToValues.get(APPL_VER1);
                    int v1 = IAUtilities.hasContent(ver1) ? Integer.parseInt(ver1) : 0;
                    String ver2 = (String)rowAttrsToValues.get(APPL_VER2);
                    int v2 = IAUtilities.hasContent(ver2) ? Integer.parseInt(ver2) : 0;
                    String ver3 = (String)rowAttrsToValues.get(APPL_VER3);
                    int v3 = IAUtilities.hasContent(ver3) ? Integer.parseInt(ver3) : 0;
                    TSApplication app1 = new TSApplication(null, (String)rowAttrsToValues.get(APPL_NAME), v1, v2, v3);
                    categoryName = String.valueOf(MessageFormat.format(Messages.getString("EventPropertySource.3200"), (String)rowAttrsToValues.get(EVENT_NAME), (String)rowAttrsToValues.get(COLLECTION_ID), (String)rowAttrsToValues.get(APPLID))) + ", " + app1.getFullName() + " (" + rowAttrsToValues.get(APPL_OPER) + ")";
                    break;
                }
                case 5200: 
                case 5300: 
                case 5500: 
                case 6100: {
                    String ver1 = (String)rowAttrsToValues.get(APPL_VER1);
                    int v1 = IAUtilities.hasContent(ver1) ? Integer.parseInt(ver1) : 0;
                    String ver2 = (String)rowAttrsToValues.get(APPL_VER2);
                    int v2 = IAUtilities.hasContent(ver2) ? Integer.parseInt(ver2) : 0;
                    String ver3 = (String)rowAttrsToValues.get(APPL_VER3);
                    int v3 = IAUtilities.hasContent(ver3) ? Integer.parseInt(ver3) : 0;
                    TSApplication app1 = new TSApplication(new Platform((String)rowAttrsToValues.get(PLATFORM)), (String)rowAttrsToValues.get(APPL_NAME), v1, v2, v3);
                    categoryName = String.valueOf(MessageFormat.format(Messages.getString("EventPropertySource.3200"), (String)rowAttrsToValues.get(EVENT_NAME), (String)rowAttrsToValues.get(COLLECTION_ID), (String)rowAttrsToValues.get(APPLID))) + ", " + rowAttrsToValues.get(PLATFORM) + ", " + app1.getFullName() + " (" + rowAttrsToValues.get(APPL_OPER) + ")";
                    break;
                }
                default: {
                    categoryName = MessageFormat.format(Messages.getString("EventPropertySource.3200"), (String)rowAttrsToValues.get(EVENT_NAME), (String)rowAttrsToValues.get(COLLECTION_ID), (String)rowAttrsToValues.get(APPLID));
                }
            }
            int j = 0;
            while (j < propertyIds.length) {
                String key = propertyIds[j];
                String suffix = String.valueOf((String)rowAttrsToValues.get(COLLECTION_ID)) + (String)rowAttrsToValues.get(APPLID) + (String)rowAttrsToValues.get(EVENT_NAME) + (String)rowAttrsToValues.get(EVENT_BINDING) + (String)rowAttrsToValues.get(CAPTURE_SPEC);
                String newKey = String.valueOf(key) + suffix + "_" + Integer.toString(i);
                this.values.put(newKey, rowAttrsToValues.get(key));
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)newKey, Messages.getString(key));
                descriptor.setCategory(categoryName);
                descriptors.add((IPropertyDescriptor)descriptor);
                ++j;
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)EventPropertySource.class.getName(), (String)"processProperties");
    }

    public Object getPropertyValue(Object id) {
        return this.values.get(id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public static int getPropertyCount() {
        return EventPropertySource.getPropertyIDs().length;
    }

    private static String[] getPropertyIDs() {
        int version = Version.getInstance().getDBVersion();
        switch (version) {
            case 3200: {
                return ia32propertyIDs;
            }
            case 5100: 
            case 5110: {
                return ia51propertyIDs;
            }
            case 5200: 
            case 5300: 
            case 5500: 
            case 6100: {
                return ia52propertyIDs;
            }
        }
        return ia32propertyIDs;
    }
}

