/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.EventPropertiesCommand;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.EventPropertySource;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.views.properties.IPropertySource;

public class Event
implements IAdaptable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(Event.class.getPackage().getName());
    private String name;
    private String captureSpec;
    private String binding;
    private List properties;
    private EventPropertySource propertySource;
    private transient Map adapters;

    public Event(String name, String captureSpec, String binding) {
        this.name = name;
        this.captureSpec = captureSpec;
        this.binding = binding;
    }

    public String getName() {
        return this.name;
    }

    public void registerAdapter(Object adapter) {
        if (this.adapters == null) {
            this.adapters = new IdentityHashMap();
        }
        this.adapters.put(adapter.getClass(), adapter);
    }

    public Object getAdapter(Class adapterType) {
        if (adapterType == IPropertySource.class) {
            if (this.propertySource == null) {
                this.propertySource = new EventPropertySource(this);
            }
            return this.propertySource;
        }
        return this.adapters == null ? null : this.adapters.get(adapterType);
    }

    public List getProperties() {
        Debug.enter((Logger)logger, (String)Event.class.getName(), (String)"getProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.properties == null) {
            this.properties = IASQLCommand.runCommandSynch(new EventPropertiesCommand(this));
        }
        Debug.exit((Logger)logger, (String)Event.class.getName(), (String)"getProperties");
        return this.properties;
    }

    public String getCaptureSpec() {
        return this.captureSpec;
    }

    public String getBinding() {
        return this.binding;
    }

    public void setName(String name) {
        this.name = name;
    }
}

