/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.bundle.ui.BundleTypeHelper;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.StoredProcedureCommand;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.CiuspepsEntryPointsModel;
import com.ibm.cics.ia.model.EntryPoint;
import com.ibm.cics.ia.model.EntryPointsModel;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.Webservice;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPEP2;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class Ciuspep2EntryPointsModel
extends CiuspepsEntryPointsModel {
    private static final Logger logger = Logger.getLogger(Ciuspep2EntryPointsModel.class.getPackage().getName());

    public Ciuspep2EntryPointsModel(Resource resource) {
        super(resource);
        if (resource instanceof Transaction) {
            this.setCallTypeParam(EntryPointsModel.CallType.T);
        } else if (resource instanceof Program) {
            this.setCallTypeParam(EntryPointsModel.CallType.P);
        } else if (resource instanceof Webservice) {
            this.setCallTypeParam(EntryPointsModel.CallType.U);
        }
    }

    @Override
    public List<EntryPoint> getFreshEntryPoints() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getFreshEntryPoints", (Object)("Thread ID: " + Thread.currentThread().getId()));
        final ArrayList entryPoints = new ArrayList();
        final String taskName = Messages.getString("Task.retrieveEntryPoints");
        Job job = new Job(taskName){

            protected IStatus run(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)"Ciuspep2EntryPointsModel.getFreshEntryPoints().ProgressMonitorDialog", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                monitor.beginTask(taskName, -1);
                StoredProcedureCommand command = new StoredProcedureCommand(){
                    private SelectionObject selectionObject;

                    public Object processRow(ResultSet rs) throws SQLException {
                        ResultSetMetaData metaData = rs.getMetaData();
                        EntryPoint entryPoint = null;
                        HashMap<String, String> additionalAttributes = new HashMap<String, String>();
                        switch (Ciuspep2EntryPointsModel.this.getCallTypeParam()) {
                            case T: 
                            case P: {
                                int i = 1;
                                while (i <= 8) {
                                    additionalAttributes.put(metaData.getColumnName(i), rs.getString(i) == null ? "" : rs.getString(i).trim());
                                    ++i;
                                }
                                additionalAttributes.put(metaData.getColumnName(12), rs.getString(12).trim());
                                entryPoint = new EntryPoint(rs.getString(9).trim(), String.valueOf(rs.getString(9).trim()) + "_OPER", BundleTypeHelper.BundlePartType.TRANSACTION, additionalAttributes);
                                entryPoints.add(entryPoint);
                                entryPoint.setUserFriendlyType(metaData.getColumnName(9));
                                entryPoint = new EntryPoint(rs.getString(10).trim(), String.valueOf(rs.getString(10).trim()) + "_OPER", BundleTypeHelper.BundlePartType.PROGRAM, additionalAttributes);
                                entryPoints.add(entryPoint);
                                entryPoint.setUserFriendlyType(metaData.getColumnName(10));
                                entryPoint = new EntryPoint(rs.getString(11).trim(), String.valueOf(rs.getString(11).trim()) + "_OPER", BundleTypeHelper.BundlePartType.PROGRAM, additionalAttributes);
                                entryPoints.add(entryPoint);
                                entryPoint.setUserFriendlyType(metaData.getColumnName(11));
                                break;
                            }
                            case U: {
                                int i = 1;
                                while (i <= 9) {
                                    additionalAttributes.put(metaData.getColumnName(i), rs.getString(i) == null ? "" : rs.getString(i).trim());
                                    ++i;
                                }
                                additionalAttributes.put(metaData.getColumnName(13), rs.getString(13).trim());
                                entryPoint = new EntryPoint(rs.getString(10).trim(), String.valueOf(rs.getString(10).trim()) + "_OPER", BundleTypeHelper.BundlePartType.PROGRAM, additionalAttributes);
                                entryPoints.add(entryPoint);
                                entryPoint.setUserFriendlyType(metaData.getColumnName(10));
                                entryPoint = new EntryPoint(rs.getString(11).trim(), String.valueOf(rs.getString(11).trim()) + "_OPER", BundleTypeHelper.BundlePartType.URIMAP, additionalAttributes);
                                entryPoints.add(entryPoint);
                                entryPoint.setUserFriendlyType(metaData.getColumnName(11));
                                entryPoint = new EntryPoint(rs.getString(12).trim(), String.valueOf(rs.getString(12).trim()) + "_OPER", BundleTypeHelper.BundlePartType.PROGRAM, additionalAttributes);
                                entryPoints.add(entryPoint);
                                entryPoint.setUserFriendlyType(metaData.getColumnName(12));
                            }
                        }
                        return entryPoints;
                    }

                    public SelectionObject getSelectionObject() {
                        String collectionId = IASQLCommand.getCollectionId().isEmpty() ? "%" : IASQLCommand.getCollectionId();
                        String applid = Ciuspep2EntryPointsModel.this.getRegionParam() != null ? Ciuspep2EntryPointsModel.this.getRegionParam() : "%";
                        return this.selectionObject == null ? (this.selectionObject = new ProcedureCIUSPEP2().getSelectionObject(Ciuspep2EntryPointsModel.this.getCallTypeParam().name(), collectionId, applid, ((Resource)(this).Ciuspep2EntryPointsModel.this.resource).getName(), Ciuspep2EntryPointsModel.this.getObjectType1Param(), Ciuspep2EntryPointsModel.this.getObjectType2Param())) : this.selectionObject;
                    }
                };
                command.setCategory("com.ibm.cics.ia.connection.db2");
                command.setAsync(false);
                command.start();
                List results = command.getResults();
                Ciuspep2EntryPointsModel.this.entryPoints.clear();
                for (Object result : results) {
                    List entryPoints2 = (List)result;
                    Ciuspep2EntryPointsModel.this.entryPoints.addAll(entryPoints2);
                }
                Ciuspep2EntryPointsModel.this.entryPoints = new ArrayList(new LinkedHashSet(Ciuspep2EntryPointsModel.this.entryPoints));
                Ciuspep2EntryPointsModel.this.enableEntryPointsBasedOnCicsTsLevel();
                Debug.exit((Logger)logger, (String)"Ciuspep2EntryPointsModel.getFreshEntryPoints().ProgressMonitorDialog", (String)"run");
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"run", (Throwable)e, new HashMap());
            IAPlugin.getDefault().logError("Unable to get entry points", e);
        }
        return this.entryPoints;
    }
}

