/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.bundle.Manifest;
import com.ibm.cics.bundle.core.CICSBundleException;
import com.ibm.cics.bundle.core.CICSBundleProject;
import com.ibm.cics.bundle.ui.BundleTypeHelper;
import com.ibm.cics.bundle.ui.BundleUIMessages;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.SimpleValidationHelper;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.model.CicsBundleResource;
import com.ibm.cics.ia.model.Ciuspep3StoredProcedureCommand;
import com.ibm.cics.ia.model.EntryPoint;
import com.ibm.cics.ia.model.EntryPointsModelBaseImpl;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPDEP;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeHint;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IllegalCICSAttributeException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CiuspdepModel
extends EntryPointsModelBaseImpl {
    private static final Logger logger = Logger.getLogger(CiuspdepModel.class.getPackage().getName());
    private List<CicsBundleResource> dependencies;
    private Map<String, List<CicsBundleResource>> projectToDependencies;

    public CiuspdepModel(Object resource) {
        this.resource = resource;
        this.dependencies = new ArrayList<CicsBundleResource>();
        this.projectToDependencies = new HashMap<String, List<CicsBundleResource>>();
    }

    @Override
    public boolean hasInvalidResources() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"hasInvalidResources", (Object)("Thread ID: " + Thread.currentThread().getId()));
        for (CicsBundleResource dependency : this.dependencies) {
            if (!dependency.isSelected() || dependency.getError() == null) continue;
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"hasInvalidResources");
            return true;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"hasInvalidResources");
        return false;
    }

    @Override
    public void validateResources() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"validateResources", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int i = 0;
        while (i < this.dependencies.size()) {
            CicsBundleResource dependency = this.dependencies.get(i);
            dependency.setError(null);
            if (dependency.isSelected()) {
                dependency.setError(this.hasValidName(dependency));
                if (dependency.getError() == null) {
                    dependency.setError(this.availableInCurrentProject(dependency));
                }
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"validateResources");
    }

    private List<CicsBundleResource> getCurrentProjectDependencies() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getCurrentProjectDependencies", (Object)("Thread ID: " + Thread.currentThread().getId()));
        List<CicsBundleResource> dependencies = new ArrayList<CicsBundleResource>();
        if (this.currentProject != null && (dependencies = this.projectToDependencies.get(this.currentProject.getProject().getName())) == null) {
            dependencies = new ArrayList();
            try {
                for (Manifest.Import projectImport : this.currentProject.getManifestImpl().getImport()) {
                    CicsBundleResource dependency = new CicsBundleResource(projectImport.getName(), projectImport.getType(), new HashMap<String, String>());
                    dependencies.add(dependency);
                }
                this.projectToDependencies.put(this.currentProject.getProject().getName(), dependencies);
            }
            catch (CICSBundleException e) {
                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"getCurrentProjectDependencies", (Throwable)e);
                IAPlugin.getDefault().logError("Unable to get the current project entry points", e);
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getCurrentProjectDependencies");
        return dependencies;
    }

    @Override
    public List<EntryPoint> getFreshEntryPoints() {
        return null;
    }

    @Override
    public List<CicsBundleResource> getCachedDependencies() {
        return this.dependencies;
    }

    @Override
    public List<CicsBundleResource> getFreshDependencies() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getFreshDependencies", (Object)("Thread ID: " + Thread.currentThread().getId()));
        final ArrayList dependencies = new ArrayList();
        final String taskName = Messages.getString("Task.retrieveDependencies");
        Job job = new Job(taskName){

            protected IStatus run(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)"CiuspdepModel.getFreshDependencies().ProgressMonitorDialog", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                monitor.beginTask(taskName, -1);
                Ciuspep3StoredProcedureCommand command = new Ciuspep3StoredProcedureCommand(CiuspdepModel.this.resource){
                    private SelectionObject selectionObject;
                    private int unnamedDependenciesCounter;
                    private String defaultDependencyName;
                    {
                        super($anonymous0);
                        this.unnamedDependenciesCounter = 0;
                        this.defaultDependencyName = "NAME";
                    }

                    @Override
                    public Object processRow(ResultSet rs) throws SQLException {
                        ResultSetMetaData metaData = rs.getMetaData();
                        if (metaData.getColumnCount() == 13 && "TYPE".equals(metaData.getColumnName(12)) && "OBJECT".equals(metaData.getColumnName(13))) {
                            HashMap<String, String> additionalAttributes = new HashMap<String, String>();
                            int i = 2;
                            while (i <= 11) {
                                additionalAttributes.put(metaData.getColumnName(i), rs.getString(i) == null ? "" : rs.getString(i).trim());
                                ++i;
                            }
                            dependencies.add(new CicsBundleResource(rs.getString(13).trim(), "http://www.ibm.com/xmlns/prod/cics/bundle/" + rs.getString(12).trim(), additionalAttributes));
                        } else if (metaData.getColumnCount() == 12 && "LIB_DATASET_NAME".equals(metaData.getColumnName(12))) {
                            HashMap<String, String> additionalAttributes = new HashMap<String, String>();
                            int i = 2;
                            while (i <= 11) {
                                additionalAttributes.put(metaData.getColumnName(i), rs.getString(i) == null ? "" : rs.getString(i).trim());
                                ++i;
                            }
                            dependencies.add(new CicsBundleResource(rs.getString(11).trim(), BundleTypeHelper.BundlePartType.LIBRARY, additionalAttributes));
                        } else if (metaData.getColumnCount() == 12 && "EVENT_BINDING".equals(metaData.getColumnName(11)) && "EB_ADAPTER".equals(metaData.getColumnName(12))) {
                            HashMap<String, String> additionalAttributes = new HashMap<String, String>();
                            int i = 2;
                            while (i <= 10) {
                                additionalAttributes.put(metaData.getColumnName(i), rs.getString(i) == null ? "" : rs.getString(i).trim());
                                ++i;
                            }
                            if (IAUtilities.hasContent(rs.getString(11))) {
                                dependencies.add(new CicsBundleResource(rs.getString(11).trim(), BundleTypeHelper.BundlePartType.EVENTBINDING, additionalAttributes));
                            }
                            if (IAUtilities.hasContent(rs.getString(12))) {
                                dependencies.add(new CicsBundleResource(rs.getString(12).trim(), BundleTypeHelper.BundlePartType.EPADAPTER, additionalAttributes));
                            }
                        } else if (metaData.getColumnCount() == 10 && "DB2ID".equals(metaData.getColumnName(10))) {
                            HashMap<String, String> additionalAttributes = new HashMap<String, String>();
                            int i = 2;
                            while (i <= 10) {
                                additionalAttributes.put(metaData.getColumnName(i), rs.getString(i) == null ? "" : rs.getString(i).trim());
                                ++i;
                            }
                            dependencies.add(new CicsBundleResource(rs.getString(10), BundleTypeHelper.BundlePartType.DB2CONN, additionalAttributes));
                        } else if (metaData.getColumnCount() == 9 && "APPL_OPER".equals(metaData.getColumnName(metaData.getColumnCount()))) {
                            HashMap<String, String> additionalAttributes = new HashMap<String, String>();
                            int i = 2;
                            while (i <= 9) {
                                additionalAttributes.put(metaData.getColumnName(i), rs.getString(i) == null ? "" : rs.getString(i).trim());
                                ++i;
                            }
                            dependencies.add(new CicsBundleResource(String.valueOf(this.defaultDependencyName) + this.unnamedDependenciesCounter++, BundleTypeHelper.BundlePartType.MQCONN, additionalAttributes));
                        }
                        return dependencies;
                    }

                    @Override
                    public SelectionObject getSelectionObject(String IN_CALLTYPE, String IN_COLLID, String IN_PLATFORM, String IN_APPLNAME, int IN_APPLVER1, int IN_APPLVER2, int IN_APPLVER3, String IN_APPLOPER) {
                        return this.selectionObject == null ? (this.selectionObject = new ProcedureCIUSPDEP().getSelectionObject(IN_CALLTYPE, IN_COLLID, IN_PLATFORM, IN_APPLNAME, IN_APPLVER1, IN_APPLVER2, IN_APPLVER3, IN_APPLOPER)) : this.selectionObject;
                    }
                };
                command.setCategory("com.ibm.cics.ia.connection.db2");
                command.setAsync(false);
                command.start();
                List results = command.getResults();
                CiuspdepModel.this.dependencies.clear();
                for (Object result : results) {
                    List entryPoints = (List)result;
                    CiuspdepModel.this.dependencies.addAll(entryPoints);
                }
                CiuspdepModel.this.dependencies = new ArrayList(new LinkedHashSet(CiuspdepModel.this.dependencies));
                Debug.exit((Logger)logger, (String)"CiuspdepModel.getFreshDependencies().ProgressMonitorDialog", (String)"run");
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"run", (Throwable)e, new HashMap());
            IAPlugin.getDefault().logError("Unable to get entry points", e);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getFreshDependencies");
        return this.dependencies;
    }

    @Override
    public void addDependenciesToProject() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"addDependenciesToProject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.currentProjectName != null) {
            CICSBundleProject cicsBundleProject = new CICSBundleProject(ResourcesPlugin.getWorkspace().getRoot().getProject(this.currentProjectName));
            for (CicsBundleResource dependency : this.dependencies) {
                if (!dependency.isSelected()) continue;
                Manifest.Import importToAdd = new Manifest.Import();
                importToAdd.setName(dependency.getName());
                importToAdd.setType(dependency.getBundlePartType().getBundlePartTypeName());
                importToAdd.setOptional(Boolean.valueOf(false));
                importToAdd.setWarn(Boolean.valueOf(false));
                try {
                    cicsBundleProject.getManifestImpl().getImport().add(importToAdd);
                }
                catch (CICSBundleException e) {
                    Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"addDependenciesToProject", (Throwable)e);
                    IAPlugin.getDefault().logError("Unable to add dependencies to the CICS bundle project", e);
                }
            }
            try {
                cicsBundleProject.setManifestImpl(cicsBundleProject.getManifestImpl());
            }
            catch (CICSBundleException e) {
                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"addDependenciesToProject", (Throwable)e);
                IAPlugin.getDefault().logError("Unable to add dependencies to the CICS bundle project", e);
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"addDependenciesToProject");
    }

    @Override
    public String hasValidName(CicsBundleResource dependency) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"hasValidName", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String name = dependency.getName();
        ICICSType type = BundleTypeHelper.getCICSType((String)dependency.getBundlePartType().getBundlePartTypeName());
        ICICSAttribute attr = type.findAttributeByCicsName(type.getNameAttribute());
        ICICSAttributeHint hint = attr.getValuesHint();
        if (hint.hasMaxLength() && name.length() > hint.getMaxLength()) {
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"hasValidName");
            return BundleUIMessages.bind((String)BundleUIMessages.ImportPropertiesDialog_nameTooLongMessage, (Object)hint.getMaxLength());
        }
        if (StringUtil.containsNonLatin1PrintableChars((String)name)) {
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"hasValidName");
            return BundleUIMessages.ImportPropertiesDialog_unprintableCharMessage;
        }
        try {
            attr.validate((Object)name);
        }
        catch (IllegalCICSAttributeException e) {
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"hasValidName");
            return BundleUIMessages.bind((String)BundleUIMessages.ImportPropertiesDialog_invalidNameMessage, (Object)e.getMessage());
        }
        try {
            SimpleValidationHelper.validateCicsAllowableCharsForLength((String)name, (int)hint.getMaxLength(), (String)BundleUIMessages.ImportPropertiesDialog_nameLabel);
        }
        catch (IllegalArgumentException e) {
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"hasValidName");
            return e.getMessage();
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"hasValidName");
        return null;
    }

    @Override
    public String availableInCurrentProject(CicsBundleResource dependency) {
        List<CicsBundleResource> projectDependencies = this.getCurrentProjectDependencies();
        return projectDependencies.contains(dependency) ? BundleUIMessages.ImportPropertiesDialog_alreadyExistsMessage : null;
    }
}

