/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.model.webservice.CIUAWSDAClient;
import com.ibm.cics.ia.runtime.AtomController;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.sm.comm.IAtomConnection;
import java.net.MalformedURLException;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.xml.sax.SAXException;

class CintRequestJob
extends Job {
    private static final Logger logger = Logger.getLogger(CintRequestJob.class.getPackage().getName());
    private CIUAWSDAClient client;
    private IConnection connection;
    private String taskName;
    private Action action;

    public CintRequestJob(String taskName, IConnection connection) throws MalformedURLException, JAXBException, SAXException {
        super(taskName);
        this.taskName = taskName;
        this.connection = connection;
        ConnectionConfiguration connectionConfig = connection.getConfiguration();
        this.client = new CIUAWSDAClient(connectionConfig.getHost(), connectionConfig.getPort(), connectionConfig.getUserID(), connectionConfig.getPassword(), connectionConfig.getSecureHint());
    }

    public CIUAWSDAClient getClient() {
        return this.client;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public IStatus run(IProgressMonitor monitor) {
        Debug.enter((Logger)logger, (String)CintCollector.class.getName(), (String)"run", (Object)("ThreadId: " + Thread.currentThread().getId()));
        monitor.beginTask(this.taskName, -1);
        try {
            this.action.run();
        }
        finally {
            monitor.done();
            Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run");
        }
        return Status.OK_STATUS;
    }

    public static void handleException(Exception e, IConnection connection, Logger logger, String className, String methodName) {
        AtomController.getInstance().disconnect((IAtomConnection)connection, e, 0, "");
        Debug.warning((Logger)logger, (String)className, (String)methodName, (String)"CintCOllector.handleException()", (Throwable)e);
        IAPlugin.getDefault().logError("Unable to get the response from the webservice", e);
    }
}

