/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.ia.commands.PropertiesForCintCollector;
import com.ibm.cics.ia.commands.WebServiceRequest;
import com.ibm.cics.ia.model.AtomContent;
import com.ibm.cics.ia.model.AtomContentElement;
import com.ibm.cics.ia.model.CintCollectorPropertySource;
import com.ibm.cics.ia.model.CintRequestJob;
import com.ibm.cics.ia.model.webservice.CIUAWSDAClient;
import com.ibm.cics.ia.model.webservice.CiuawsdaServiceResponse;
import com.ibm.cics.ia.model.webservice.Region;
import com.ibm.cics.ia.runtime.AtomController;
import com.ibm.cics.ia.runtime.Messages;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAttribute;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.views.properties.IPropertySource;

public class CintCollector
extends AtomContent
implements IAdaptable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CintCollector.class.getPackage().getName());
    private CintCollectorPropertySource propertySource;
    private transient Map adapters;
    private Map properties;
    private com.ibm.cics.ia.model.Region region;
    private String state = "";
    private String name = "";

    public Object getAdapter(Class adapterType) {
        if (adapterType == IPropertySource.class) {
            if (this.propertySource == null) {
                this.propertySource = new CintCollectorPropertySource(this);
            }
            return this.propertySource;
        }
        return null;
    }

    public Map getProperties() {
        Debug.enter((Logger)logger, (String)CintCollector.class.getName(), (String)"getProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        PropertiesForCintCollector propertiesForCollector = new PropertiesForCintCollector(this);
        propertiesForCollector.start();
        this.properties = propertiesForCollector.getResult();
        Debug.exit((Logger)logger, (String)CintCollector.class.getName(), (String)"getProperties", (Object)("properties size: " + (this.properties != null ? Integer.valueOf(this.properties.size()) : "")));
        return this.properties;
    }

    public Map<String, String> getPropertiesForEditor() {
        Debug.enter((Logger)logger, (String)CintCollector.class.getName(), (String)"getPropertiesForEditor", (Object)("Thread ID: " + Thread.currentThread().getId()));
        AtomContentElement element = this.getContentElement().getFirstElementByName("region");
        final String applid = element.getAttribute("applid");
        final String sysid = element.getAttribute("sysid");
        String connectionID = this.getConnectionID();
        final IConnection connection = AtomController.getInstance().getConnection(connectionID);
        final HashMap<String, String> propertiesForEditor = new HashMap<String, String>();
        try {
            CintRequestJob job = new CintRequestJob(MessageFormat.format(Messages.getString("IAOperationsView.statsCintRequestTask"), applid), connection);
            final CIUAWSDAClient client = job.getClient();
            Action action = new Action(){

                public void run() {
                    try {
                        Field[] fields;
                        CiuawsdaServiceResponse response = client.reguestRegionPropertiesForEditing(applid, sysid);
                        WebServiceRequest.showMessage(response.getMessage());
                        if (response.getMessage().getMsgnum().trim().equals("CIU2101W")) {
                            return;
                        }
                        Region region = response.getRegion();
                        Field[] fieldArray = fields = Region.class.getDeclaredFields();
                        int n = fields.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Field field = fieldArray[n2];
                            field.setAccessible(true);
                            XmlAttribute xmlAttr = field.getAnnotation(XmlAttribute.class);
                            if (xmlAttr != null && field.get(region) != null) {
                                propertiesForEditor.put(xmlAttr.name(), field.get(region).toString().trim());
                            }
                            ++n2;
                        }
                    }
                    catch (Exception e) {
                        CintRequestJob.handleException(e, connection, logger, ((Object)((Object)this)).getClass().getName(), "run");
                    }
                }
            };
            job.setAction(action);
            job.setRule(WebServiceRequest.MUTEX_RULE);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                Debug.warning((Logger)logger, (String)CintCollector.class.getName(), (String)"getPropertiesForEditor", (String)"empty catch", (Throwable)e);
            }
        }
        catch (Exception e) {
            CintRequestJob.handleException(e, connection, logger, this.getClass().getName(), "getPropertiesForEditor");
        }
        Debug.exit((Logger)logger, (String)CintCollector.class.getName(), (String)"getPropertiesForEditor", (Object)("propertiesForEditor size: " + propertiesForEditor.size()));
        return propertiesForEditor;
    }

    public String getState() {
        Debug.enter((Logger)logger, (String)CintCollector.class.getName(), (String)"getState", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.state.equals("")) {
            AtomContentElement element = this.getContentElement().getFirstElementByName("region");
            this.state = element.getAttribute("state");
        }
        Debug.exit((Logger)logger, (String)CintCollector.class.getName(), (String)"getState", (Object)("state: " + this.state));
        return this.state;
    }

    public String getName() {
        Debug.enter((Logger)logger, (String)CintCollector.class.getName(), (String)"getName", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.name.equals("")) {
            AtomContentElement element = this.getContentElement().getFirstElementByName("region");
            this.name = element.getAttribute("applid");
        }
        Debug.exit((Logger)logger, (String)CintCollector.class.getName(), (String)"getName", (Object)("name: " + this.name));
        return this.name;
    }

    public void setRegion(com.ibm.cics.ia.model.Region aRegion) {
        this.region = aRegion;
    }

    public com.ibm.cics.ia.model.Region getRegion() {
        return this.region;
    }

    public void updateWith(CintCollector collector) {
        Debug.enter((Logger)logger, (String)CintCollector.class.getName(), (String)"updateWith", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "collector: " + (collector == null ? collector : collector.getName())});
        this.name = collector.name;
        this.region = collector.region;
        this.state = collector.state;
        this.contentElement = collector.contentElement;
        this.properties = collector.properties;
        this.propertySource = collector.propertySource;
        this.adapters = collector.adapters;
        Debug.exit((Logger)logger, (String)CintCollector.class.getName(), (String)"updateWith");
    }

    public void clearPropertySource() {
        this.propertySource = null;
    }
}

