/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.PropertiesForCincCollector;
import com.ibm.cics.ia.model.AtomContent;
import com.ibm.cics.ia.model.AtomContentElement;
import com.ibm.cics.ia.model.CincCollectorPropertySource;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.views.properties.IPropertySource;

public class CincCollector
extends AtomContent
implements IAdaptable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CincCollector.class.getPackage().getName());
    private CincCollectorPropertySource propertySource;
    private transient Map adapters;
    private Map properties;
    private String userId = "";
    private String state = "";
    private boolean controllable;
    private boolean deleted = false;
    private HashMap<String, String> mroRegions;

    public Object getAdapter(Class adapterType) {
        if (adapterType == IPropertySource.class) {
            if (this.propertySource == null) {
                this.propertySource = new CincCollectorPropertySource(this);
            }
            return this.propertySource;
        }
        return null;
    }

    public void clearPropertySource() {
        this.propertySource = null;
    }

    public Map getProperties() {
        Debug.enter((Logger)logger, (String)CincCollector.class.getName(), (String)"getProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.properties == null || this.mroRegions == null || this.properties.get("cincstate") == null || ((Map)this.properties.get("cincstate")).size() == 0) {
            PropertiesForCincCollector propertiesForCollector = new PropertiesForCincCollector(this);
            propertiesForCollector.start();
            this.properties = propertiesForCollector.getResult();
        }
        Debug.exit((Logger)logger, (String)CincCollector.class.getName(), (String)"getProperties");
        return this.properties;
    }

    public Map getFreshProperties() {
        Debug.enter((Logger)logger, (String)CincCollector.class.getName(), (String)"getFreshProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        PropertiesForCincCollector propertiesForCollector = new PropertiesForCincCollector(this);
        propertiesForCollector.start();
        this.properties = propertiesForCollector.getResult();
        Debug.exit((Logger)logger, (String)CincCollector.class.getName(), (String)"getFreshProperties");
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public String getState() {
        Debug.enter((Logger)logger, (String)CincCollector.class.getName(), (String)"getState", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.state.equals("")) {
            AtomContentElement element = this.getContentElement().getFirstElementByName("cincuser");
            if (element != null) {
                this.state = element.getAttribute("status");
            } else {
                element = this.getContentElement().getFirstElementByName("group");
                if (element != null) {
                    this.state = element.getAttribute("state");
                }
            }
        }
        Debug.exit((Logger)logger, (String)CincCollector.class.getName(), (String)"getState");
        return this.state;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setControllable(boolean isControllable) {
        this.controllable = isControllable;
    }

    public boolean isControllable() {
        return this.controllable;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public HashMap<String, String> getMroRegions() {
        Debug.enter((Logger)logger, (String)CincCollector.class.getName(), (String)"getMroRegions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.mroRegions == null) {
            this.mroRegions = new HashMap();
        }
        Debug.exit((Logger)logger, (String)CincCollector.class.getName(), (String)"getMroRegions");
        return this.mroRegions;
    }

    public void updateWith(CincCollector collector) {
        Debug.enter((Logger)logger, (String)CincCollector.class.getName(), (String)"updateWith", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.userId = collector.userId;
        this.controllable = collector.controllable;
        this.deleted = collector.deleted;
        if (collector.mroRegions != null) {
            this.mroRegions = collector.mroRegions;
        }
        this.state = collector.state;
        this.contentElement = collector.contentElement;
        this.propertySource = collector.propertySource;
        this.adapters = collector.adapters;
        this.properties = collector.properties;
        Debug.exit((Logger)logger, (String)CincCollector.class.getName(), (String)"updateWith");
    }
}

