/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.bundle.ui.BundleTypeHelper;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.Map;
import java.util.logging.Logger;

public class CicsBundleResource {
    private static final Logger logger = Logger.getLogger(CicsBundleResource.class.getPackage().getName());
    private String name;
    private BundleTypeHelper.BundlePartType bundlePartType;
    private String error;
    private String userFriendlyType;
    private boolean isSelected = true;
    private Map<String, String> additionalAttributes;

    public CicsBundleResource(String name, String typeName, Map<String, String> additionalAttributes) {
        this.name = name;
        this.additionalAttributes = additionalAttributes;
        this.bundlePartType = typeName.equals("http://www.ibm.com/xmlns/prod/cics/bundle/TRANSID") ? BundleTypeHelper.BundlePartType.TRANSACTION : (typeName.equals("http://www.ibm.com/xmlns/prod/cics/bundle/TSMODEL") ? BundleTypeHelper.BundlePartType.TSQMODEL : BundleTypeHelper.BundlePartType.lookupByBundlePartTypeName((String)typeName));
        this.userFriendlyType = this.bundlePartType != null ? this.bundlePartType.name() : typeName;
    }

    public CicsBundleResource(String name, BundleTypeHelper.BundlePartType bundlePartType, Map<String, String> additionalAttributes) {
        this.name = name;
        this.additionalAttributes = additionalAttributes;
        this.bundlePartType = bundlePartType;
        this.userFriendlyType = bundlePartType.name();
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getError() {
        return this.error;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BundleTypeHelper.BundlePartType getBundlePartType() {
        return this.bundlePartType;
    }

    public void setBundlePartType(BundleTypeHelper.BundlePartType bundlePartTime) {
        this.bundlePartType = bundlePartTime;
    }

    public String getUserFriendlyType() {
        return this.userFriendlyType;
    }

    public void setUserFriendlyType(String userFriendlyType) {
        this.userFriendlyType = userFriendlyType;
    }

    public String getCollectionId() {
        return this.additionalAttributes.get("COLLECTION_ID");
    }

    public String getApplid() {
        return this.additionalAttributes.get("APPLID");
    }

    public String getPlatform() {
        return this.additionalAttributes.get("PLATFORM");
    }

    public String getFullApplName() {
        if (IAUtilities.hasContent(this.additionalAttributes.get("APPL_NAME"))) {
            return String.valueOf(this.additionalAttributes.get("APPL_NAME")) + " (" + this.additionalAttributes.get("APPL_VER1") + "." + this.additionalAttributes.get("APPL_VER2") + "." + this.additionalAttributes.get("APPL_VER3") + ")";
        }
        return "";
    }

    public String getApplOperation() {
        return this.additionalAttributes.get("APPL_OPER");
    }

    public String getObject() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String groupingResource = this.additionalAttributes.get("OBJECT");
        if (groupingResource == null) {
            groupingResource = this.additionalAttributes.get("RESNAME");
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getObject");
        return groupingResource;
    }

    public String getDb2Id() {
        return this.additionalAttributes.get("DB2ID");
    }

    public Map<String, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bundlePartType == null ? 0 : this.bundlePartType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CicsBundleResource other = (CicsBundleResource)obj;
        if (this.bundlePartType != other.bundlePartType) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

