/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.CSect;
import com.ibm.cics.ia.model.Messages;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class CSectPropertySource
implements IPropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CSectPropertySource.class.getPackage().getName());
    public static String CSECT_NAME = "CSECT_NAME";
    public static String DSNAME = "DSNAME";
    public static String LINKED = "LINKED";
    public static String HMASPZAP_DATE = "HMASPZAP_DATE";
    public static String HMASPZAP_DATA = "HMASPZAP_DATA";
    public static String PROGLEN = "PROGLEN";
    public static String PROGRAM = "PROGRAM";
    public static String TRAN_1_DATE = "TRAN_1_DATE";
    public static String TRAN_1_NAME = "TRAN_1_NAME";
    public static String TRAN_1_VERSION = "TRAN_1_VERSION";
    public static String TRAN_2_DATE = "TRAN_2_DATE";
    public static String TRAN_2_NAME = "TRAN_2_NAME";
    public static String TRAN_2_VERSION = "TRAN_2_VERSION";
    public static String USER_DATA_DATE = "USER_DATA_DATE";
    public static String USER_DATA = "USER_DATA";
    private static final String[] propertyIDs = new String[]{DSNAME, PROGRAM, PROGLEN, LINKED, CSECT_NAME, TRAN_1_DATE, TRAN_1_NAME, TRAN_1_VERSION, TRAN_2_DATE, TRAN_2_NAME, TRAN_2_VERSION, USER_DATA_DATE, USER_DATA, HMASPZAP_DATE, HMASPZAP_DATA};
    protected Map values = new HashMap();
    private IPropertyDescriptor[] propertyDescriptors;
    private CSect csect;

    public CSectPropertySource(CSect aCsect) {
        this.csect = aCsect;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Debug.enter((Logger)logger, (String)CSectPropertySource.class.getName(), (String)"getPropertyDescriptors", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.propertyDescriptors == null) {
            List properties = this.csect.getProperties();
            if (properties != null) {
                this.propertyDescriptors = new IPropertyDescriptor[propertyIDs.length * properties.size()];
                this.processProperties(properties);
            } else {
                this.propertyDescriptors = new IPropertyDescriptor[0];
            }
        }
        Debug.exit((Logger)logger, (String)CSectPropertySource.class.getName(), (String)"getPropertyDescriptors");
        return this.propertyDescriptors;
    }

    private void processProperties(List properties) {
        Debug.enter((Logger)logger, (String)CSectPropertySource.class.getName(), (String)"processProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int i = 0;
        while (i < properties.size()) {
            Map m = (Map)properties.get(i);
            int j = 0;
            while (j < propertyIDs.length) {
                String key = propertyIDs[j];
                String newKey = String.valueOf((String)m.get(DSNAME)) + "_" + (String)m.get(PROGRAM) + "_" + key + "_" + Integer.toString(i);
                this.values.put(newKey, m.get(key));
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)newKey, Messages.getString(key));
                descriptor.setCategory(MessageFormat.format(Messages.getString("CSectPropertySource.0"), (String)m.get(CSECT_NAME), (String)m.get(PROGRAM), (String)m.get(DSNAME)));
                this.propertyDescriptors[j + i * CSectPropertySource.propertyIDs.length] = descriptor;
                ++j;
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)CSectPropertySource.class.getName(), (String)"processProperties");
    }

    public static int getPropertyCount() {
        return propertyIDs.length;
    }

    public Object getEditableValue() {
        return null;
    }

    public Object getPropertyValue(Object id) {
        return this.values.get(id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

