/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.commands.PlatformsForResourceCommand;
import com.ibm.cics.ia.commands.RegionsForResourceCommand;
import com.ibm.cics.ia.commands.SourceInteractionsForResourceCommand;
import com.ibm.cics.ia.commands.SourceProgramInteractionsForResourceCommand;
import com.ibm.cics.ia.commands.SourceTransactionInteractionsForResourceCommand;
import com.ibm.cics.ia.model.Resource;
import java.util.List;
import java.util.logging.Logger;

public class CICSResource
extends Resource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CICSResource.class.getPackage().getName());
    private static final long serialVersionUID = -5327992244036503991L;

    public CICSResource(String resourceTypeName, String resourceName) {
        super(resourceTypeName, resourceName);
    }

    @Override
    public List getSourceInteractions() {
        Debug.enter((Logger)logger, (String)CICSResource.class.getName(), (String)"getSourceInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceInteractions == null) {
            this.sourceInteractions = IASQLCommand.runCommandSynch(new SourceInteractionsForResourceCommand(this));
        }
        Debug.exit((Logger)logger, (String)CICSResource.class.getName(), (String)"getSourceInteractions");
        return this.sourceInteractions;
    }

    @Override
    public Command createGetRegionsCommand() {
        return new RegionsForResourceCommand(this);
    }

    @Override
    public Command createGetPlatformsCommand() {
        return new PlatformsForResourceCommand(this);
    }

    @Override
    public List getProperties() {
        return null;
    }

    @Override
    public List getSourceProgramInteractions() {
        Debug.enter((Logger)logger, (String)CICSResource.class.getName(), (String)"getSourceProgramInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceProgramInteractions == null) {
            this.sourceProgramInteractions = IASQLCommand.runCommandSynch(new SourceProgramInteractionsForResourceCommand(this));
        }
        Debug.exit((Logger)logger, (String)CICSResource.class.getName(), (String)"getSourceProgramInteractions");
        return this.sourceProgramInteractions;
    }

    @Override
    public List getSourceTransactionInteractions() {
        Debug.enter((Logger)logger, (String)CICSResource.class.getName(), (String)"getSourceTransactionInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceTransactionInteractions == null) {
            this.sourceTransactionInteractions = IASQLCommand.runCommandSynch(new SourceTransactionInteractionsForResourceCommand(this));
        }
        Debug.exit((Logger)logger, (String)CICSResource.class.getName(), (String)"getSourceTransactionInteractions");
        return this.sourceTransactionInteractions;
    }
}

