/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AtomContentElement {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AtomContentElement.class.getPackage().getName());
    private LinkedHashMap<String, String> attributes = new LinkedHashMap();
    private ArrayList<AtomContentElement> elements = new ArrayList();
    private String name = "";
    private String value = "";

    public String getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public List<AtomContentElement> getChildElementsByName(String aName) {
        Debug.enter((Logger)logger, (String)AtomContentElement.class.getName(), (String)"getElementsByName", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ArrayList<AtomContentElement> newElements = new ArrayList<AtomContentElement>();
        for (AtomContentElement element : this.elements) {
            if (!aName.equals(element.getName())) continue;
            newElements.add(element);
        }
        Debug.exit((Logger)logger, (String)AtomContentElement.class.getName(), (String)"getElementsByName");
        return newElements;
    }

    public AtomContentElement getFirstElementByName(String aName) {
        Debug.enter((Logger)logger, (String)AtomContentElement.class.getName(), (String)"getFirstElementByName", (Object)("Thread ID: " + Thread.currentThread().getId()));
        AtomContentElement result = null;
        for (AtomContentElement element : this.elements) {
            if (!aName.equals(element.getName())) continue;
            result = element;
            break;
        }
        Debug.exit((Logger)logger, (String)AtomContentElement.class.getName(), (String)"getFirstElementByName");
        return result;
    }

    public void addElement(AtomContentElement element) {
        this.elements.add(element);
    }

    public boolean containsElement(String aName) {
        Debug.enter((Logger)logger, (String)AtomContentElement.class.getName(), (String)"containsElement", (Object)("Thread ID: " + Thread.currentThread().getId()));
        boolean result = false;
        for (AtomContentElement element : this.elements) {
            if (!aName.equals(element.getName())) continue;
            result = true;
        }
        Debug.exit((Logger)logger, (String)AtomContentElement.class.getName(), (String)"containsElement");
        return result;
    }

    public boolean containsAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public static AtomContentElement parse(Element elem) {
        Debug.enter((Logger)logger, (String)AtomContentElement.class.getName(), (String)"parse", (Object)("Thread ID: " + Thread.currentThread().getId()));
        AtomContentElement element = new AtomContentElement();
        element.setName(elem.getNodeName());
        NamedNodeMap map = elem.getAttributes();
        int j = 0;
        while (j < map.getLength()) {
            Attr attr = (Attr)map.item(j);
            element.setAttribute(attr.getName(), attr.getValue().trim());
            ++j;
        }
        NodeList nodeList = elem.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Text text;
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                Element child = (Element)node;
                AtomContentElement newElement = AtomContentElement.parse(child);
                element.addElement(newElement);
            } else if (node instanceof Text && (text = (Text)node).getData() != null) {
                element.value = String.valueOf(element.value) + text.getData().trim();
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)AtomContentElement.class.getName(), (String)"parse");
        return element;
    }

    public String toString() {
        Debug.enter((Logger)logger, (String)AtomContentElement.class.getName(), (String)"toString", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append("<");
            sb.append(this.getName());
            if (this.attributes != null && !this.attributes.isEmpty()) {
                Set<String> keys = this.attributes.keySet();
                for (String key : keys) {
                    sb.append(" ");
                    sb.append(key);
                    sb.append("=");
                    sb.append("\"");
                    sb.append(AtomContentElement.escape(this.attributes.get(key)));
                    sb.append("\"");
                }
            }
            sb.append(">");
            if (this.elements != null && this.elements.size() != 0) {
                for (AtomContentElement element : this.elements) {
                    sb.append(element.toString());
                }
            }
            if (this.value != null) {
                sb.append(AtomContentElement.escape(this.value));
            }
            sb.append("<");
            sb.append("/");
            sb.append(this.getName());
            sb.append(">");
            Debug.exit((Logger)logger, (String)AtomContentElement.class.getName(), (String)"toString");
            return sb.toString();
        }
        Debug.exit((Logger)logger, (String)AtomContentElement.class.getName(), (String)"toString");
        return null;
    }

    public static String escape(String input) {
        Debug.enter((Logger)logger, (String)AtomContentElement.class.getName(), (String)"escape", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String amps = input.replaceAll("&", "&amp;");
        String quotes = amps.replaceAll("\"", "&quot;");
        String lts = quotes.replaceAll("<", "&lt;");
        String gts = lts.replaceAll(">", "&gt;");
        Debug.exit((Logger)logger, (String)AtomContentElement.class.getName(), (String)"escape");
        return gts;
    }
}

