/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.ia.model.AtomContentElement;
import com.ibm.cics.ia.model.CincCollector;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.runtime.AtomController;
import com.ibm.cics.ia.sm.comm.IAtomConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class AtomContent {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AtomContent.class.getPackage().getName());
    private String atomConnection;
    protected AtomContentElement contentElement = new AtomContentElement();
    private AtomContentElement updateElement;

    public void setConnectionID(String connectionID) {
        this.atomConnection = connectionID;
    }

    public boolean isConnectedToAtom() {
        String connectionID = this.getConnectionID();
        IConnection connection = AtomController.getInstance().getConnection(connectionID);
        if (connection instanceof IAtomConnection) {
            return ((IAtomConnection)connection).isAtomService();
        }
        return false;
    }

    public String getConnectionID() {
        return this.atomConnection;
    }

    public void setContentElement(AtomContentElement element) {
        this.contentElement = element;
    }

    public AtomContentElement getContentElement() {
        return this.contentElement;
    }

    public static AtomContent parse(AtomContentElement contentElement, String connectionID) {
        AtomContent oldCollector;
        AtomContentElement element;
        AtomContent collector;
        Debug.enter((Logger)logger, (String)AtomContent.class.getName(), (String)"parse", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "contentElement: " + (contentElement == null ? contentElement : contentElement.getName()), "connectionId: " + connectionID});
        AtomContent result = null;
        if (contentElement.containsElement("region")) {
            result = new CintCollector();
        } else if (contentElement.containsElement("group")) {
            result = new CincCollector();
            ((CincCollector)result).setControllable(true);
            ((CincCollector)result).setDeleted(false);
        } else if (contentElement.containsElement("cincuser")) {
            result = new CincCollector();
            ((CincCollector)result).setControllable(false);
            ((CincCollector)result).setDeleted(false);
        } else if (contentElement.containsElement("added")) {
            result = new CincCollector();
            ((CincCollector)result).setControllable(false);
            ((CincCollector)result).setDeleted(false);
        } else if (contentElement.containsElement("deleted")) {
            result = new CincCollector();
            ((CincCollector)result).setControllable(false);
            ((CincCollector)result).setDeleted(true);
        } else {
            result = contentElement.containsElement("details") ? new AtomContent() : (contentElement.containsElement("flow") ? new AtomContent() : new AtomContent());
        }
        result.setContentElement(contentElement);
        result.setConnectionID(connectionID);
        if (result instanceof CintCollector) {
            collector = (CintCollector)result;
            element = collector.getContentElement().getFirstElementByName("region");
            String applid = element.getAttribute("applid");
            if (applid != null) {
                Region region = ResourceFactory.getSingleton().getRegion(applid);
                ((CintCollector)collector).setRegion(region);
                region.setCintCollector((CintCollector)collector);
            }
            if ((oldCollector = ResourceFactory.getSingleton().getCintCollector(connectionID, applid)) != null) {
                ((CintCollector)oldCollector).updateWith((CintCollector)collector);
                result = oldCollector;
            } else {
                ResourceFactory.getSingleton().putCintCollector(connectionID, applid, (CintCollector)collector);
            }
        }
        if (result instanceof CincCollector) {
            collector = (CincCollector)result;
            element = collector.getContentElement().getFirstElementByName("group");
            if (element == null) {
                element = collector.getContentElement().getFirstElementByName("cincuser");
            }
            if (element == null) {
                element = collector.getContentElement().getFirstElementByName("added");
            }
            if (element == null) {
                element = collector.getContentElement().getFirstElementByName("deleted");
            }
            if (element != null) {
                String userId = element.getAttribute("nameid");
                ((CincCollector)collector).setUserId(userId);
                if (contentElement.containsElement("cincstate")) {
                    HashMap<String, String[]> regionMap = new HashMap<String, String[]>();
                    List<AtomContentElement> elements = contentElement.getChildElementsByName("cincstate");
                    int i = 0;
                    while (i < elements.size()) {
                        String applid = elements.get(i).getAttribute("app");
                        String sysid = elements.get(i).getAttribute("sysid");
                        String cf_total = elements.get(i).getAttribute("cf_total");
                        String curr_state = elements.get(i).getAttribute("curr_state");
                        String number = elements.get(i).getAttribute("number");
                        if (!applid.equals("")) {
                            regionMap.put(number, new String[]{applid, sysid, cf_total, curr_state});
                        }
                        ++i;
                    }
                    HashMap<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
                    properties.put("cincstate", regionMap);
                    properties.put("details", contentElement.getFirstElementByName("group").getAttributes());
                    ((CincCollector)collector).setProperties(properties);
                }
                if ((oldCollector = ResourceFactory.getSingleton().getCincCollector(connectionID, userId)) != null) {
                    ((CincCollector)oldCollector).updateWith((CincCollector)collector);
                    result = oldCollector;
                } else {
                    ResourceFactory.getSingleton().putCincCollector(connectionID, userId, (CincCollector)collector);
                }
            }
        }
        Debug.exit((Logger)logger, (String)AtomContent.class.getName(), (String)"parse");
        return result;
    }

    public static AtomContent parse(Element elem, String connectionID) {
        AtomContent oldCollector;
        AtomContentElement element;
        AtomContent collector;
        Debug.enter((Logger)logger, (String)AtomContent.class.getName(), (String)"parse", (Object)("Thread ID: " + Thread.currentThread().getId()));
        AtomContent result = null;
        AtomContentElement contentElement = AtomContentElement.parse(elem);
        if (contentElement.containsElement("region")) {
            result = new CintCollector();
        } else if (contentElement.containsElement("group")) {
            result = new CincCollector();
            ((CincCollector)result).setControllable(true);
            ((CincCollector)result).setDeleted(false);
        } else if (contentElement.containsElement("cincuser")) {
            result = new CincCollector();
            ((CincCollector)result).setControllable(false);
            ((CincCollector)result).setDeleted(false);
        } else if (contentElement.containsElement("added")) {
            result = new CincCollector();
            ((CincCollector)result).setControllable(false);
            ((CincCollector)result).setDeleted(false);
        } else if (contentElement.containsElement("deleted")) {
            result = new CincCollector();
            ((CincCollector)result).setControllable(false);
            ((CincCollector)result).setDeleted(true);
        } else if (contentElement.containsElement("details")) {
            result = new AtomContent();
        } else if (contentElement.containsElement("flow")) {
            result = new AtomContent();
        } else if (contentElement.containsElement("message")) {
            result = new AtomContent();
        }
        result.contentElement = contentElement;
        result.setConnectionID(connectionID);
        if (result instanceof CintCollector) {
            collector = (CintCollector)result;
            element = collector.getContentElement().getFirstElementByName("region");
            String applid = element.getAttribute("applid");
            if (applid != null) {
                Region region = ResourceFactory.getSingleton().getRegion(applid);
                ((CintCollector)collector).setRegion(region);
                region.setCintCollector((CintCollector)collector);
            }
            if ((oldCollector = ResourceFactory.getSingleton().getCintCollector(connectionID, applid)) != null) {
                ((CintCollector)oldCollector).updateWith((CintCollector)collector);
                result = oldCollector;
            } else {
                ResourceFactory.getSingleton().putCintCollector(connectionID, applid, (CintCollector)collector);
            }
        }
        if (result instanceof CincCollector) {
            collector = (CincCollector)result;
            element = collector.getContentElement().getFirstElementByName("group");
            if (element == null) {
                element = collector.getContentElement().getFirstElementByName("cincuser");
            }
            if (element == null) {
                element = collector.getContentElement().getFirstElementByName("added");
            }
            if (element == null) {
                element = collector.getContentElement().getFirstElementByName("deleted");
            }
            if (element != null) {
                String userId = element.getAttribute("nameid");
                ((CincCollector)collector).setUserId(userId);
                if (contentElement.containsElement("cincstate")) {
                    HashMap<String, String[]> regionMap = new HashMap<String, String[]>();
                    List<AtomContentElement> elements = contentElement.getChildElementsByName("cincstate");
                    int i = 0;
                    while (i < elements.size()) {
                        String applid = elements.get(i).getAttribute("app");
                        String sysid = elements.get(i).getAttribute("sysid");
                        String cf_total = elements.get(i).getAttribute("cf_total");
                        String curr_state = elements.get(i).getAttribute("curr_state");
                        String number = elements.get(i).getAttribute("number");
                        if (!applid.equals("")) {
                            regionMap.put(number, new String[]{applid, sysid, cf_total, curr_state});
                        }
                        ++i;
                    }
                    HashMap<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
                    properties.put("cincstate", regionMap);
                    properties.put("details", contentElement.getFirstElementByName("group").getAttributes());
                    ((CincCollector)collector).setProperties(properties);
                }
                if ((oldCollector = ResourceFactory.getSingleton().getCincCollector(connectionID, userId)) != null) {
                    ((CincCollector)oldCollector).updateWith((CincCollector)collector);
                    result = oldCollector;
                } else {
                    ResourceFactory.getSingleton().putCincCollector(connectionID, userId, (CincCollector)collector);
                }
            }
        }
        Debug.exit((Logger)logger, (String)AtomContent.class.getName(), (String)"parse");
        return result;
    }

    public void setUpdateElement(AtomContentElement element) {
        this.updateElement = element;
    }

    public AtomContentElement getUpdateElement() {
        return this.updateElement;
    }
}

