/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.ia.model.AffGroup;
import com.ibm.cics.ia.model.AffinityType;
import com.ibm.cics.ia.model.IAffinityBuilderInput;
import com.ibm.cics.ia.model.IAffinityBuilderInputGroup;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.ResourceFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AffinityReport
implements IAffinityBuilderInput {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private static final String XML_HEADING_AFFINITY_REPORT = "<!DOCTYPE selection SYSTEM \"platform:/plugin/com.ibm.cics.ia.runtime/report.dtd\">\n";
    private static final String XML_REPORT = "Report";
    private static final String XML_REGION = "Region";
    private static final String XML_TYPE = "Type";
    private static final String XML_AFFINITY_REPORT_TYPE = "Affinity";
    private static final String XML_DESCRIPTION = "Description";
    private static final String XML_GENERATED = "Generated";
    private Region region;
    private List<AffinityType> affinityTypes;
    private HashMap<AffinityType, List<AffGroup>> affinityTypesToAffGroups = new HashMap();
    private Date generationDate;
    private String description;
    private static final Logger logger = Logger.getLogger(AffinityReport.class.getPackage().getName());

    public void write(File file) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            this.write(out);
        }
        catch (IOException e) {
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"parse", (String)"empty catch", (Throwable)e);
        }
    }

    public void write(Writer writer) {
        Debug.enter((Logger)logger, (String)AffinityReport.class.getName(), (String)"write", (Object)("ThreadID: " + Thread.currentThread().getId()));
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            this.persist(doc, null);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource xmlSource = new DOMSource(doc);
            StreamResult result = new StreamResult(writer);
            writer.write(XML_VERSION);
            writer.write(XML_HEADING_AFFINITY_REPORT);
            transformer.transform(xmlSource, result);
            writer.close();
        }
        catch (IOException e) {
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"write", (String)"empty catch", (Throwable)e);
            Debug.exit((Logger)logger, (String)AffinityReport.class.getName(), (String)"write");
        }
        catch (TransformerException e) {
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"write", (String)"empty catch", (Throwable)e);
            Debug.exit((Logger)logger, (String)AffinityReport.class.getName(), (String)"write");
        }
        catch (ParserConfigurationException e) {
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"write", (String)"empty catch", (Throwable)e);
            Debug.exit((Logger)logger, (String)AffinityReport.class.getName(), (String)"write");
        }
        Debug.exit((Logger)logger, (String)AffinityReport.class.getName(), (String)"write");
    }

    public void persist(Document doc, Element parent) {
        Element element = doc.createElement(XML_REPORT);
        if (parent != null) {
            parent.appendChild(element);
        } else {
            doc.appendChild(element);
        }
        element.setAttribute(XML_GENERATED, DATE_FORMAT.format(this.generationDate));
        element.setAttribute(XML_TYPE, XML_AFFINITY_REPORT_TYPE);
        element.setAttribute(XML_REGION, this.region.getName());
        Element descriptionElement = doc.createElement(XML_DESCRIPTION);
        descriptionElement.setTextContent(this.description);
        element.appendChild(descriptionElement);
        for (AffinityType affinityType : this.affinityTypes) {
            Element affinityTypeElement = affinityType.persist(doc, element);
            List<AffGroup> groups = this.affinityTypesToAffGroups.get((Object)affinityType);
            if (groups == null) continue;
            for (AffGroup affGroup : groups) {
                affGroup.persist(doc, affinityTypeElement);
            }
        }
    }

    public static AffinityReport parse(File file) {
        try {
            return AffinityReport.parse(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            Debug.warning((Logger)logger, (String)AffinityReport.class.getName(), (String)"parse", (String)"empty catch", (Throwable)e);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static AffinityReport parse(InputStream is) {
        block25: {
            Debug.enter((Logger)AffinityReport.logger, (String)AffinityReport.class.getName(), (String)"parse", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "parse input stream"});
            res = null;
            if (is != null) {
                try {
                    reader = new InputStreamReader(is, "UTF-8");
                    inputSource = new InputSource(reader);
                    inputSource.setEncoding("UTF-8");
                    dbf = DocumentBuilderFactory.newInstance();
                    db = dbf.newDocumentBuilder();
                    doc = db.parse(inputSource);
                    doc.getDocumentElement().normalize();
                    list = doc.getChildNodes();
                    i = 0;
                    while (i < list.getLength()) {
                        if (list.item(i) instanceof Element && list.item(i).getNodeName().equals("Report")) {
                            res = AffinityReport.parseDOM((Element)list.item(i));
                        }
                        ++i;
                    }
                }
                catch (ParserConfigurationException e) {
                    Debug.warning((Logger)AffinityReport.logger, (String)AffinityReport.class.getName(), (String)"parse input stream", (String)"empty catch", (Throwable)e);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            Debug.warning((Logger)AffinityReport.logger, (String)AffinityReport.class.getName(), (String)"parse input stream", (String)"exception at input stream close()", (Throwable)e);
                            Debug.exit((Logger)AffinityReport.logger, (String)AffinityReport.class.getName(), (String)"parse input stream", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId(), "exception catched"});
                        }
                    }
                    break block25;
                }
                catch (SAXException e) {
                    Debug.warning((Logger)AffinityReport.logger, (String)AffinityReport.class.getName(), (String)"parse input stream", (String)"empty catch", (Throwable)e);
                    ** if (is == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            Debug.warning((Logger)AffinityReport.logger, (String)AffinityReport.class.getName(), (String)"parse input stream", (String)"exception at input stream close()", (Throwable)e);
                            Debug.exit((Logger)AffinityReport.logger, (String)AffinityReport.class.getName(), (String)"parse input stream", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId(), "exception catched"});
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block25;
                    }
                }
                catch (IOException e) {
                    Debug.warning((Logger)AffinityReport.logger, (String)AffinityReport.class.getName(), (String)"parse input stream", (String)"empty catch", (Throwable)e);
                    ** if (is == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            Debug.warning((Logger)AffinityReport.logger, (String)AffinityReport.class.getName(), (String)"parse input stream", (String)"exception at input stream close()", (Throwable)e);
                            Debug.exit((Logger)AffinityReport.logger, (String)AffinityReport.class.getName(), (String)"parse input stream", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId(), "exception catched"});
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block25;
                    }
                    {
                        catch (Throwable var9_17) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {
                                    Debug.warning((Logger)AffinityReport.logger, (String)AffinityReport.class.getName(), (String)"parse input stream", (String)"exception at input stream close()", (Throwable)e);
                                    Debug.exit((Logger)AffinityReport.logger, (String)AffinityReport.class.getName(), (String)"parse input stream", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId(), "exception catched"});
                                }
                            }
                            throw var9_17;
                        }
                    }
                }
                if (is == null) break block25;
                try {
                    is.close();
                }
                catch (IOException e) {
                    Debug.warning((Logger)AffinityReport.logger, (String)AffinityReport.class.getName(), (String)"parse input stream", (String)"exception at input stream close()", (Throwable)e);
                    Debug.exit((Logger)AffinityReport.logger, (String)AffinityReport.class.getName(), (String)"parse input stream", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId(), "exception catched"});
                }
            }
        }
        Debug.exit((Logger)AffinityReport.logger, (String)AffinityReport.class.getName(), (String)"parse", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId(), "result description: " + res.getDescription(), "result region:  " + res.getRegion().getName()});
        return res;
    }

    private static AffinityReport parseDOM(Element item) {
        String regionString;
        Debug.enter((Logger)logger, (String)AffinityReport.class.getName(), (String)"parseDOM", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "item tag: " + (item == null ? item : item.getTagName())});
        Region region = null;
        ArrayList<AffinityType> affinityTypes = new ArrayList<AffinityType>();
        HashMap affinityTypesToGroups = new HashMap();
        AffinityReport result = null;
        Date generationDate = null;
        String description = null;
        String reportType = item.getAttribute(XML_TYPE);
        if (!XML_AFFINITY_REPORT_TYPE.equals(reportType)) {
            Debug.exit((Logger)logger, (String)AffinityReport.class.getName(), (String)"parseDOM", (Object)("Thread ID: " + Thread.currentThread().getId()));
            return null;
        }
        String generationDateString = item.getAttribute(XML_GENERATED);
        if (Utilities.hasContent((String)generationDateString)) {
            try {
                generationDate = DATE_FORMAT.parse(generationDateString);
            }
            catch (ParseException ex) {
                Debug.warning((Logger)logger, (String)AffinityReport.class.getName(), (String)"parseDOM", (String)"empty catch", (Throwable)ex);
            }
        }
        if (Utilities.hasContent((String)(regionString = item.getAttribute(XML_REGION)))) {
            region = ResourceFactory.getSingleton().getRegion(regionString);
        }
        NodeList list = item.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i) instanceof Element) {
                AffinityType affinityType;
                Element item2 = (Element)list.item(i);
                if (item2.getNodeName().equals(XML_DESCRIPTION)) {
                    description = item2.getTextContent();
                }
                if (item2.getNodeName().equals("AffinityType") && (affinityType = AffinityType.parseDOM(item2)) != null) {
                    NodeList list2 = item2.getChildNodes();
                    affinityTypes.add(affinityType);
                    ArrayList<AffGroup> affGroups = new ArrayList<AffGroup>();
                    affinityTypesToGroups.put(affinityType, affGroups);
                    int j = 0;
                    while (j < list2.getLength()) {
                        AffGroup affGroup;
                        if (list2.item(j) instanceof Element && list2.item(j).getNodeName().equals("AffinityGroup") && (affGroup = AffGroup.parseDOM((Element)list2.item(j))) != null) {
                            affGroups.add(affGroup);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (generationDate != null && region != null && affinityTypes.size() > 0) {
            result = new AffinityReport(region, affinityTypes);
            result.generationDate = generationDate;
            result.affinityTypesToAffGroups = affinityTypesToGroups;
            result.description = description;
        }
        Debug.exit((Logger)logger, (String)AffinityReport.class.getName(), (String)"parseDOM", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId(), "result description: " + result.getDescription(), "result region: " + result.getRegion().getName()});
        return result;
    }

    public AffinityReport(Region region, List<AffinityType> affinityTypes) {
        this.region = region;
        this.affinityTypes = affinityTypes;
        this.generationDate = new Date();
        this.description = Messages.getString("AffinityReport.Description.default");
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public void setAffinityTypes(List<AffinityType> affinityTypes) {
        this.affinityTypes = affinityTypes;
    }

    public List<AffinityType> getAffinityTypes() {
        return this.affinityTypes;
    }

    public void setAffinityGroups(AffinityType affinityType, List<AffGroup> affGroups) {
        this.affinityTypesToAffGroups.put(affinityType, affGroups);
    }

    public List<AffGroup> getAffinityGroups(AffinityType affinityType) {
        return this.affinityTypesToAffGroups.get((Object)affinityType);
    }

    @Override
    public Date getGenerationDate() {
        return this.generationDate;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<IAffinityBuilderInputGroup> getAffinityGroups() {
        ArrayList<IAffinityBuilderInputGroup> result = new ArrayList<IAffinityBuilderInputGroup>();
        for (AffinityType affinityType : this.affinityTypes) {
            List<AffGroup> affGroups = this.affinityTypesToAffGroups.get((Object)affinityType);
            for (AffGroup affGroup : affGroups) {
                if (!"Y".equals(affGroup.getBuild())) continue;
                result.add(affGroup);
            }
        }
        return result;
    }
}

