/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.ia.model.BuiltAffGroup;
import com.ibm.cics.ia.model.IAffinityBuilderInput;
import com.ibm.cics.ia.model.IAffinityBuilderInputGroup;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AffinityBuilderOutput
implements IAffinityBuilderInput {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private static final String XML_HEADING_AFFINITY_REPORT = "<!DOCTYPE selection SYSTEM \"platform:/plugin/com.ibm.cics.ia.runtime/report.dtd\">\n";
    private static final String XML_BUILD = "Build";
    private static final String XML_TYPE = "Type";
    private static final String XML_AFFINITY_BUILD_TYPE = "Affinity";
    private static final String XML_DESCRIPTION = "Description";
    private static final String XML_GENERATED = "Generated";
    private static final String XML_CONTEXT = "Context";
    private static final String XML_MATCH = "Match";
    private static final String XML_STATE = "State";
    private static final String XML_DATASET = "DataSet";
    private static final String XML_NAME = "Name";
    private static final String XML_MEMBER = "Member";
    private static final String XML_CMAS_NAME = "CMASName";
    private static final String XML_OUTPUT_USER_NAME = "OutputUserName";
    private static final String XML_PRINT_NODE = "PrintNode";
    private static final String XML_JCL = "Jcl";
    private static final String XML_ACTION = "Action";
    private List<IAffinityBuilderInputGroup> affGroups;
    private Date generationDate = new Date();
    private String description = Messages.getString("AffinityReport.Description.default");
    private String context;
    private String match;
    private String state;
    private String dataSetName;
    private String memberName;
    private String cmasName;
    private String outputUserName;
    private String printNode;
    private String jcl;
    private Action action;
    private static final Logger logger = Logger.getLogger(AffinityBuilderOutput.class.getPackage().getName());

    public void write(File file) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            this.write(out);
        }
        catch (IOException e) {
            Debug.warning((Logger)logger, (String)AffinityBuilderOutput.class.getName(), (String)"write", (String)"empty catch", (Throwable)e);
        }
    }

    public void write(Writer writer) {
        Debug.enter((Logger)logger, (String)AffinityBuilderOutput.class.getName(), (String)"write", (Object)("ThreadID: " + Thread.currentThread().getId()));
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            this.persist(doc, null);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource xmlSource = new DOMSource(doc);
            StreamResult result = new StreamResult(writer);
            writer.write(XML_VERSION);
            writer.write(XML_HEADING_AFFINITY_REPORT);
            transformer.transform(xmlSource, result);
            writer.close();
        }
        catch (IOException e) {
            Debug.warning((Logger)logger, (String)AffinityBuilderOutput.class.getName(), (String)"write", (String)"empty catch", (Throwable)e);
        }
        catch (TransformerException e) {
            Debug.warning((Logger)logger, (String)AffinityBuilderOutput.class.getName(), (String)"write", (String)"empty catch", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            Debug.warning((Logger)logger, (String)AffinityBuilderOutput.class.getName(), (String)"write", (String)"empty catch", (Throwable)e);
        }
        Debug.exit((Logger)logger, (String)AffinityBuilderOutput.class.getName(), (String)"write");
    }

    public void persist(Document doc, Element parent) {
        Debug.enter((Logger)logger, (String)AffinityBuilderOutput.class.getName(), (String)"persist", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "doc: " + (doc == null ? doc : doc.getLocalName()), "parent: " + (parent == null ? parent : parent.getTagName())});
        Element element = doc.createElement(XML_BUILD);
        if (parent != null) {
            parent.appendChild(element);
        } else {
            doc.appendChild(element);
        }
        element.setAttribute(XML_GENERATED, DATE_FORMAT.format(this.generationDate));
        element.setAttribute(XML_TYPE, XML_AFFINITY_BUILD_TYPE);
        element.setAttribute(XML_CONTEXT, this.context);
        element.setAttribute(XML_MATCH, this.match);
        element.setAttribute(XML_STATE, this.state);
        element.setAttribute(XML_CMAS_NAME, this.cmasName);
        element.setAttribute(XML_OUTPUT_USER_NAME, this.outputUserName);
        element.setAttribute(XML_PRINT_NODE, this.printNode);
        element.setAttribute(XML_ACTION, this.action.toString());
        Element descriptionElement = doc.createElement(XML_DESCRIPTION);
        descriptionElement.setTextContent(this.description);
        element.appendChild(descriptionElement);
        Element jclElement = doc.createElement(XML_JCL);
        jclElement.setTextContent(this.jcl);
        element.appendChild(jclElement);
        Element dataSetElement = doc.createElement(XML_DATASET);
        dataSetElement.setAttribute(XML_NAME, this.dataSetName);
        dataSetElement.setAttribute(XML_MEMBER, this.memberName);
        element.appendChild(dataSetElement);
        for (IAffinityBuilderInputGroup affGroup : this.affGroups) {
            affGroup.persist(doc, element);
        }
        Debug.exit((Logger)logger, (String)AffinityBuilderOutput.class.getName(), (String)"persist", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    public static AffinityBuilderOutput parse(File file) {
        Debug.enter((Logger)logger, (String)AffinityBuilderOutput.class.getName(), (String)"parse", (Object[])new String[]{"ThreadID: " + Thread.currentThread().getId(), "file: " + (file == null ? file : file.getName())});
        try {
            AffinityBuilderOutput result = AffinityBuilderOutput.parse(new FileInputStream(file));
            Debug.exit((Logger)logger, (String)AffinityBuilderOutput.class.getName(), (String)"parse", (Object)("result: " + (result == null ? result : result.getDescription())));
            return result;
        }
        catch (FileNotFoundException e) {
            Debug.warning((Logger)logger, (String)AffinityBuilderOutput.class.getName(), (String)"parse", (String)"empty catch", (Throwable)e);
            Debug.exit((Logger)logger, (String)AffinityBuilderOutput.class.getName(), (String)"parse", (Object)"return null");
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static AffinityBuilderOutput parse(InputStream is) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 11[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static AffinityBuilderOutput parseDOM(Element item) {
        Debug.enter((Logger)logger, (String)AffinityBuilderOutput.class.getName(), (String)"parseDOM", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "item: " + (item == null ? item : item.getLocalName())});
        Object region = null;
        ArrayList<IAffinityBuilderInputGroup> builtAffGroups = new ArrayList<IAffinityBuilderInputGroup>();
        AffinityBuilderOutput result = null;
        Date generationDate = null;
        String description = null;
        String jcl = "";
        String reportType = item.getAttribute(XML_TYPE);
        if (!XML_AFFINITY_BUILD_TYPE.equals(reportType)) {
            Debug.exit((Logger)logger, (String)AffinityBuilderOutput.class.getName(), (String)"parseDOM", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId(), "return null"});
            return null;
        }
        String generationDateString = item.getAttribute(XML_GENERATED);
        if (Utilities.hasContent((String)generationDateString)) {
            try {
                generationDate = DATE_FORMAT.parse(generationDateString);
            }
            catch (ParseException ex) {
                Debug.warning((Logger)logger, (String)AffinityBuilderOutput.class.getName(), (String)"parseDOM", (String)"empty catch", (Throwable)ex);
            }
        }
        String contextString = item.getAttribute(XML_CONTEXT);
        String stateString = item.getAttribute(XML_STATE);
        String matchString = item.getAttribute(XML_MATCH);
        String cmasName = "";
        String outputUserName = "";
        String printNode = "";
        cmasName = item.getAttribute(XML_CMAS_NAME);
        outputUserName = item.getAttribute(XML_OUTPUT_USER_NAME);
        printNode = item.getAttribute(XML_PRINT_NODE);
        String actionString = item.getAttribute(XML_ACTION);
        Action action = !IAUtilities.hasContent(actionString) ? Action.Execute : Action.valueOf(actionString);
        if (action == null) {
            action = Action.Execute;
        }
        String datasetName = "";
        String memberName = "";
        NodeList list = item.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i) instanceof Element) {
                BuiltAffGroup builtAffGroup;
                Element item2 = (Element)list.item(i);
                if (item2.getNodeName().equals(XML_DESCRIPTION)) {
                    description = item2.getTextContent();
                } else if (item2.getNodeName().equals(XML_JCL)) {
                    jcl = item2.getTextContent();
                } else if (item2.getNodeName().equals(XML_DATASET)) {
                    datasetName = item2.getAttribute(XML_NAME);
                    memberName = item2.getAttribute(XML_MEMBER);
                } else if (item2.getNodeName().equals("AffinityGroup") && (builtAffGroup = BuiltAffGroup.parseDOM(item2)) != null) {
                    builtAffGroups.add(builtAffGroup);
                }
            }
            ++i;
        }
        if (generationDate != null) {
            result = new AffinityBuilderOutput();
            result.context = contextString;
            result.state = stateString;
            result.match = matchString;
            result.generationDate = generationDate;
            result.description = description;
            result.jcl = jcl;
            result.affGroups = builtAffGroups;
            result.dataSetName = datasetName;
            result.memberName = memberName;
            result.cmasName = cmasName;
            result.outputUserName = outputUserName;
            result.printNode = printNode;
            result.action = action;
        }
        Debug.exit((Logger)logger, (String)AffinityBuilderOutput.class.getName(), (String)"parseDOM", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId(), "result description: " + result.getDescription(), "dataset: " + result.getDataSetName()});
        return result;
    }

    public List<IAffinityBuilderInputGroup> getAffinityGroups() {
        return this.affGroups;
    }

    public void setAffinityGroups(List<? extends IAffinityBuilderInputGroup> groups) {
        this.affGroups = groups;
    }

    @Override
    public Date getGenerationDate() {
        return this.generationDate;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getMatch() {
        return this.match;
    }

    public void setMatch(String match) {
        this.match = match;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    public void setDataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getCmasName() {
        return this.cmasName;
    }

    public void setCmasName(String cmasName) {
        this.cmasName = cmasName;
    }

    public String getOutputUserName() {
        return this.outputUserName;
    }

    public void setOutputUserName(String outputUserName) {
        this.outputUserName = outputUserName;
    }

    public String getPrintNode() {
        return this.printNode;
    }

    public void setPrintNode(String printNode) {
        this.printNode = printNode;
    }

    public String getJcl() {
        return this.jcl;
    }

    public void setJcl(String jcl) {
        this.jcl = jcl;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CONTEXT " + this.context + ";\n");
        for (IAffinityBuilderInputGroup affGroup : this.affGroups) {
            sb.append(affGroup.toString());
        }
        return sb.toString();
    }

    public static enum Action {
        Check,
        Execute;

    }
}

