/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.ia.commands.RequestSchedulingRule;
import com.ibm.cics.ia.model.AtomContent;
import com.ibm.cics.ia.model.AtomContentElement;
import com.ibm.cics.ia.model.AtomDefinitions;
import com.ibm.cics.ia.model.webservice.CIUAWSCFClient;
import com.ibm.cics.ia.model.webservice.CIUAWSCFRequestProgramInterface;
import com.ibm.cics.ia.model.webservice.CIUAWSCFResponseProgramInterface;
import com.ibm.cics.ia.model.webservice.CIUAWSDAClient;
import com.ibm.cics.ia.model.webservice.CincUser;
import com.ibm.cics.ia.model.webservice.CiuawsdaServiceResponse;
import com.ibm.cics.ia.model.webservice.Region;
import com.ibm.cics.ia.runtime.AtomController;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Messages;
import com.ibm.cics.ia.sm.comm.IAtomConnection;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAttribute;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class WebServiceRequest
extends Job {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(WebServiceRequest.class.getPackage().getName());
    public static final String CINT_START_ACTION = "CINT_START_ACTION";
    public static final String CINT_STOP_ACTION = "CINT_STOP_ACTION";
    public static final String CINC_START_ACTION = "CINC_START_ACTION";
    public static final String CINC_STOP_ACTION = "CINC_STOP_ACTION";
    public static final String CINC_SAVE_ACTION = "CINC_SAVE_ACTION";
    public static String CINT_RESET_REGION_DEFAULTS_ACTION = "com.ibm.cics.ia.ui.cintCollector.resetDefaults";
    public static final RequestSchedulingRule MUTEX_RULE = new RequestSchedulingRule();
    private List<AtomContent> atomContents;
    private AtomContentElement requestElement;
    private IAtomConnection connection;
    private String taskName;
    private String applid;
    private String sysid;
    private String action;
    private String userId;
    protected String message = "";

    public WebServiceRequest(String taskName, IAtomConnection connection) {
        super(taskName);
        this.connection = connection;
        this.taskName = taskName;
        this.setRule(MUTEX_RULE);
    }

    public WebServiceRequest(String taskName, String applid, String sysid, String action, IAtomConnection connection) {
        this(taskName, connection);
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"WebServiceRequest", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "taskName: " + taskName, "applid: " + applid, "sysid: " + sysid, "action: " + action, "connection: " + (connection == null ? connection : connection.getName())});
        this.applid = applid;
        this.sysid = sysid;
        this.action = action;
        this.taskName = taskName;
        this.createRequestElement();
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"WebServiceRequest");
    }

    public WebServiceRequest(String taskName, AtomContentElement actionElement, IAtomConnection connection) {
        this(taskName, actionElement.getAttribute("applid"), actionElement.getAttribute("sysid"), actionElement.getValue(), connection);
        this.requestElement = actionElement;
    }

    public WebServiceRequest(String taskName, AtomContentElement actionElement, String action, IAtomConnection connection) {
        this(taskName, connection);
        this.requestElement = actionElement;
        this.action = action;
    }

    public WebServiceRequest(String taskName, String action, String userId, IAtomConnection connection) {
        this(taskName, connection);
        this.userId = userId;
        this.action = action;
    }

    public void createRequestElement() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createRequestElement", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.requestElement = new AtomContentElement();
        this.requestElement.setName("content");
        this.requestElement.setAttribute("type", "text/xml");
        AtomContentElement actionElement = new AtomContentElement();
        actionElement.setName("action");
        actionElement.setAttribute("applid", this.applid);
        actionElement.setAttribute("sysid", this.sysid);
        actionElement.setValue(this.action);
        this.requestElement.addElement(actionElement);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createRequestElement");
    }

    public synchronized IStatus run(IProgressMonitor monitor) {
        block66: {
            AtomContentElement actionElement;
            Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
            monitor.beginTask(this.taskName, -1);
            if (this.connection == null || !this.connection.isConnected()) {
                monitor.done();
                Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run", (Object)"return OK_STATUS");
                return Status.OK_STATUS;
            }
            boolean updated = false;
            if (this.requestElement != null && (actionElement = this.requestElement.getFirstElementByName("action")) != null) {
                updated = this.requestElement.getFirstElementByName("action").getValue().equals("update".toUpperCase());
            }
            CIUAWSDAClient ciuawsdaClient = null;
            CIUAWSCFClient ciuawscfClient = null;
            try {
                try {
                    ciuawsdaClient = new CIUAWSDAClient(this.connection.getConfiguration().getHost(), this.connection.getConfiguration().getPort(), this.connection.getConfiguration().getUserID(), this.connection.getConfiguration().getPassword(), this.connection.getConfiguration().getSecureHint());
                    ciuawscfClient = new CIUAWSCFClient(this.connection.getConfiguration().getHost(), this.connection.getConfiguration().getPort(), this.connection.getConfiguration().getUserID(), this.connection.getConfiguration().getPassword(), this.connection.getConfiguration().getSecureHint());
                    if ("ACTION_GET_COLLECTORS_LIST".equals(this.action)) {
                        CiuawsdaServiceResponse ciuawsdaServiceResponse = ciuawsdaClient.requestRegionList();
                        this.atomContents = WebServiceRequest.serviceResponseToAtomContents(ciuawsdaServiceResponse, this.connection.getConfiguration().getID(), updated);
                        ciuawsdaServiceResponse = ciuawsdaClient.requestUsersList();
                        WebServiceRequest.showMessage(ciuawsdaServiceResponse.getMessage());
                        this.atomContents.addAll(WebServiceRequest.serviceResponseToAtomContents(ciuawsdaServiceResponse, this.connection.getConfiguration().getID(), updated));
                        CIUAWSCFResponseProgramInterface.CfOutBuf cfOutBuf = ciuawscfClient.requestStatistic();
                        this.atomContents.add(WebServiceRequest.createAtomContentWithGroupElement(this.connection.getConfiguration().getID(), cfOutBuf, updated));
                        WebServiceRequest.showMessage(cfOutBuf.getMessage());
                    } else if (CINT_START_ACTION.equals(this.action)) {
                        CiuawsdaServiceResponse serviceResponse = ciuawsdaClient.startRegion(this.applid, this.sysid);
                        this.atomContents = WebServiceRequest.serviceResponseToAtomContents(serviceResponse, this.connection.getConfiguration().getID(), updated);
                        WebServiceRequest.showMessage(serviceResponse.getMessage());
                    } else if (CINT_STOP_ACTION.equals(this.action)) {
                        CiuawsdaServiceResponse serviceResponse = ciuawsdaClient.stopRegion(this.applid, this.sysid);
                        this.atomContents = WebServiceRequest.serviceResponseToAtomContents(serviceResponse, this.connection.getConfiguration().getID(), updated);
                        WebServiceRequest.showMessage(serviceResponse.getMessage());
                    } else if ("PAUSE".equals(this.action)) {
                        CiuawsdaServiceResponse serviceResponse = ciuawsdaClient.pauseRegion(this.applid, this.sysid);
                        this.atomContents = WebServiceRequest.serviceResponseToAtomContents(serviceResponse, this.connection.getConfiguration().getID(), updated);
                        WebServiceRequest.showMessage(serviceResponse.getMessage());
                    } else if ("CONTINUE".equals(this.action)) {
                        CiuawsdaServiceResponse serviceResponse = ciuawsdaClient.continueRegion(this.applid, this.sysid);
                        this.atomContents = WebServiceRequest.serviceResponseToAtomContents(serviceResponse, this.connection.getConfiguration().getID(), updated);
                        WebServiceRequest.showMessage(serviceResponse.getMessage());
                    } else if (CINT_RESET_REGION_DEFAULTS_ACTION.equals(this.action)) {
                        CiuawsdaServiceResponse serviceResponse = ciuawsdaClient.setRegionDefaults(this.applid, this.sysid);
                        this.atomContents = WebServiceRequest.serviceResponseToAtomContents(serviceResponse, this.connection.getConfiguration().getID(), true);
                        WebServiceRequest.showMessage(serviceResponse.getMessage());
                    } else if ("STATS".equals(this.action)) {
                        CiuawsdaServiceResponse serviceResponse = ciuawsdaClient.reguestRegionProperties(this.applid, this.sysid);
                        this.atomContents = WebServiceRequest.serviceResponseToAtomContents(serviceResponse, this.connection.getConfiguration().getID(), updated);
                        WebServiceRequest.showMessage(serviceResponse.getMessage());
                    } else if (updated) {
                        AtomContentElement contentElement = this.requestElement.getFirstElementByName("action");
                        String applId = contentElement.getAttribute("applid");
                        String sysId = contentElement.getAttribute("sysid");
                        String applMode = contentElement.getAttribute("appl_mode");
                        String applCtxt = contentElement.getAttribute("appl_ctxt");
                        String applName = contentElement.getAttribute("appl_name");
                        String applVer1 = contentElement.getAttribute("appl_ver1");
                        String applVer2 = contentElement.getAttribute("appl_ver2");
                        String applVer3 = contentElement.getAttribute("appl_ver3");
                        CiuawsdaServiceResponse serviceResponse = ciuawsdaClient.saveAppOptions(applId, sysId, applMode, applCtxt, applName, applVer1, applVer2, applVer3);
                        this.atomContents = WebServiceRequest.serviceResponseToAtomContents(serviceResponse, this.connection.getConfiguration().getID(), updated);
                        WebServiceRequest.showMessage(serviceResponse.getMessage());
                    } else if ("STAT".equals(this.action)) {
                        CIUAWSCFResponseProgramInterface.CfOutBuf cfOutBuf = ciuawscfClient.requestStatistic();
                        WebServiceRequest.showMessage(cfOutBuf.getMessage());
                        AtomContent atomContent = WebServiceRequest.createAtomContentWithGroupElement(this.connection.getConfiguration().getID(), cfOutBuf, updated);
                        CiuawsdaServiceResponse ciuawsdaServiceResponse = ciuawsdaClient.requestRegionList();
                        AtomContentElement availAppsElement = new AtomContentElement();
                        availAppsElement.setName("availapps");
                        for (Region region : ciuawsdaServiceResponse.getRegions().getRegions()) {
                            AtomContentElement appElement = new AtomContentElement();
                            appElement.setName("app");
                            appElement.setAttribute("sysid", region.getSysid());
                            appElement.setValue(region.getApplid());
                            availAppsElement.addElement(appElement);
                        }
                        atomContent.getContentElement().getFirstElementByName("group").addElement(availAppsElement);
                        this.atomContents = new ArrayList<AtomContent>();
                        this.atomContents.add(atomContent);
                        WebServiceRequest.showMessage(ciuawsdaServiceResponse.getMessage());
                    } else if ("ADMINDTL".equals(this.action)) {
                        CIUAWSCFResponseProgramInterface.CfOutBuf cfOutBuf = ciuawscfClient.requestDetails(this.userId);
                        AtomContent atomContent = WebServiceRequest.createAtomContentWithDetailsElement(this.connection.getConfiguration().getID(), cfOutBuf, updated);
                        this.atomContents = new ArrayList<AtomContent>();
                        this.atomContents.add(atomContent);
                        WebServiceRequest.showMessage(cfOutBuf.getMessage());
                    } else if (CINC_START_ACTION.equals(this.action)) {
                        CIUAWSCFResponseProgramInterface.CfOutBuf cfOutBuf = ciuawscfClient.startCollector();
                        AtomContent atomContent = WebServiceRequest.createAtomContentWithGroupElement(this.connection.getConfiguration().getID(), cfOutBuf, updated);
                        this.atomContents = new ArrayList<AtomContent>();
                        this.atomContents.add(atomContent);
                        WebServiceRequest.showMessage(cfOutBuf.getMessage());
                    } else if (CINC_STOP_ACTION.equals(this.action)) {
                        CIUAWSCFResponseProgramInterface.CfOutBuf cfOutBuf = ciuawscfClient.stopCollector();
                        AtomContent atomContent = WebServiceRequest.createAtomContentWithGroupElement(this.connection.getConfiguration().getID(), cfOutBuf, updated);
                        this.atomContents = new ArrayList<AtomContent>();
                        this.atomContents.add(atomContent);
                        WebServiceRequest.showMessage(cfOutBuf.getMessage());
                    } else if (CINC_SAVE_ACTION.equals(this.action)) {
                        CIUAWSCFRequestProgramInterface.CfInBuf cfInBuf = new CIUAWSCFRequestProgramInterface.CfInBuf();
                        AtomContentElement updateElement = this.requestElement.getFirstElementByName("update");
                        CIUAWSCFRequestProgramInterface.CfInBuf.Settings settings = new CIUAWSCFRequestProgramInterface.CfInBuf.Settings();
                        cfInBuf.setSettings(settings);
                        for (Map.Entry<String, String> entry : updateElement.getAttributes().entrySet()) {
                            if (entry.getKey().equals("authority")) {
                                settings.setAuthority(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("cmdflowid")) {
                                settings.setCmdflowid(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("dcall")) {
                                settings.setDcall(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("exitname")) {
                                settings.setExitname(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("nameid")) {
                                cfInBuf.setInUser(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("journalcc")) {
                                settings.setJournalcc(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("max_recs")) {
                                settings.setMaxRecs(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("max_task")) {
                                settings.setMaxTask(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("prog_exlist_name")) {
                                settings.setProgExlistName(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("termid")) {
                                settings.setTermid(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("tran1")) {
                                settings.setTran1(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("tran2")) {
                                settings.setTran2(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("tran3")) {
                                settings.setTran3(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("tran4")) {
                                settings.setTran4(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("tran5")) {
                                settings.setTran5(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("tran_exlist_name")) {
                                settings.setTranExlistName(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("tuserid")) {
                                settings.setTuserid(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("appl_mode")) {
                                settings.setAppMode(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("appl_name")) {
                                settings.setAppName(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("appl_ver1")) {
                                settings.setAppVer1(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("appl_ver2")) {
                                settings.setAppVer2(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("appl_ver3")) {
                                settings.setAppVer3(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("comm_inlist_name")) {
                                settings.setCommInlistName(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("kcics")) {
                                settings.setKcics(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("kyims")) {
                                settings.setKyims(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("keymq")) {
                                settings.setKeymq(entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("kydb2")) {
                                settings.setKydb2(entry.getValue());
                                continue;
                            }
                            if (!entry.getKey().equals("kynat")) continue;
                            settings.setKynat(entry.getValue());
                        }
                        List<AtomContentElement> apps = updateElement.getChildElementsByName("app");
                        for (AtomContentElement app : apps) {
                            CIUAWSCFRequestProgramInterface.CfInBuf.Settings.Cincstate cincState = new CIUAWSCFRequestProgramInterface.CfInBuf.Settings.Cincstate();
                            cincState.setSysid(app.getAttribute("sysid"));
                            cincState.setApp(app.getValue());
                            cfInBuf.getSettings().getCincstates().add(cincState);
                        }
                        CIUAWSCFResponseProgramInterface.CfOutBuf cfOutBuf = ciuawscfClient.saveDetails(cfInBuf);
                        AtomContent atomContent = WebServiceRequest.createAtomContentWithGroupElement(this.connection.getConfiguration().getID(), cfOutBuf, true);
                        this.atomContents = new ArrayList<AtomContent>();
                        this.atomContents.add(atomContent);
                        WebServiceRequest.showMessage(cfOutBuf.getMessage());
                    }
                }
                catch (Exception e) {
                    if (ciuawsdaClient != null) {
                        AtomController.getInstance().disconnect(this.connection, e, ciuawsdaClient.getLastHttpResponseCode(), ciuawsdaClient.getLastHttpResponseMsg());
                    } else if (ciuawscfClient != null) {
                        AtomController.getInstance().disconnect(this.connection, e, ciuawscfClient.getLastHttpResponseCode(), ciuawscfClient.getLastHttpResponseMsg());
                    } else {
                        AtomController.getInstance().disconnect(this.connection, e, 0, "");
                    }
                    Debug.warning((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"run", (String)"Unable to get the response from the webservice", (Throwable)e);
                    IAPlugin.getDefault().logError("Unable to get the response from the webservice", e);
                    monitor.done();
                    break block66;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run", (Object)"return OK_STATUS");
        return Status.OK_STATUS;
    }

    public List<AtomContent> getAtomContents() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getAtomContents", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.atomContents == null) {
            this.atomContents = new ArrayList<AtomContent>();
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getAtomContents", (Object)("result size: " + this.atomContents.size()));
        return this.atomContents;
    }

    private static AtomContentElement createChildElement(Region region, AtomContentElement rootElement, boolean updated) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        Debug.enter((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"createChildElement", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "region ApplName: " + (region == null ? region : region.getApplName()), "rootElement: " + rootElement.getName(), "updated: " + updated});
        AtomContentElement childElement = new AtomContentElement();
        childElement.setName(updated ? "updated" : "region");
        Field[] fieldArray = fields = Region.class.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.setAccessible(true);
            XmlAttribute xmlAttr = field.getAnnotation(XmlAttribute.class);
            if (xmlAttr != null && field.get(region) != null) {
                childElement.setAttribute(xmlAttr.name(), field.get(region).toString().trim());
            }
            ++n2;
        }
        rootElement.addElement(childElement);
        Debug.exit((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"createChildElement", (Object)("childElement: " + childElement.getName()));
        return childElement;
    }

    public static AtomContent createAtomContent(String connectionId, Region region, boolean updated) throws IllegalAccessException {
        Debug.enter((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"createAtomContent", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "connectionId: " + connectionId, "region applName: " + (region == null ? region : region.getApplName()), "updated: " + updated});
        AtomContentElement rootElement = new AtomContentElement();
        rootElement.setName("content");
        AtomContentElement childElement = WebServiceRequest.createChildElement(region, rootElement, updated);
        AtomContent atomContent = AtomContent.parse(rootElement, connectionId);
        Debug.exit((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"createAtomContent");
        return atomContent;
    }

    public static AtomContent createAtomContent(String connectionId, CincUser cincUser, boolean updated) throws IllegalAccessException {
        Debug.enter((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"createAtomContent", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "connectionId: " + connectionId, "cincUser NameId: " + (cincUser == null ? cincUser : cincUser.getNameid()), "updated: " + updated});
        AtomContentElement rootElement = new AtomContentElement();
        rootElement.setName("content");
        AtomContentElement childElement = WebServiceRequest.createChildElement(cincUser, rootElement, updated);
        AtomContent atomContent = AtomContent.parse(rootElement, connectionId);
        Debug.exit((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"createAtomContent");
        return atomContent;
    }

    public static AtomContent createAtomContentWithGroupElement(String connectionId, CIUAWSCFResponseProgramInterface.CfOutBuf cfOutBuf, boolean updated) throws IllegalAccessException {
        Debug.enter((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"createAtomContentWithGroupElement", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "connectionId: " + connectionId, "cfOutBuf applName: " + (cfOutBuf == null ? cfOutBuf : cfOutBuf.getApplName()), "updated: " + updated});
        AtomContentElement rootElement = new AtomContentElement();
        rootElement.setName("content");
        AtomContentElement childElement = WebServiceRequest.createGroupElement(cfOutBuf, rootElement, updated);
        AtomContent atomContent = AtomContent.parse(rootElement, connectionId);
        Debug.exit((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"createAtomContentWithGroupElement");
        return atomContent;
    }

    public static AtomContent createAtomContentWithDetailsElement(String connectionId, CIUAWSCFResponseProgramInterface.CfOutBuf cfOutBuf, boolean updated) throws IllegalAccessException {
        Debug.enter((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"createAtomContentWithDetailsElement", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "connectionId: " + connectionId, "cfOutBuf applName: " + (cfOutBuf == null ? cfOutBuf : cfOutBuf.getApplName()), "updated: " + updated});
        AtomContentElement rootElement = new AtomContentElement();
        rootElement.setName("content");
        AtomContentElement detailsElement = new AtomContentElement();
        detailsElement.setName("details");
        detailsElement.setAttribute("status", cfOutBuf.getState().trim());
        WebServiceRequest.addCommonAttributes(cfOutBuf, detailsElement);
        rootElement.addElement(detailsElement);
        int regionNumber = 1;
        for (CIUAWSCFResponseProgramInterface.CfOutBuf.Cincstate cincState : cfOutBuf.getCincstates()) {
            AtomContentElement applidElement = new AtomContentElement();
            applidElement.setName("applid");
            applidElement.setAttribute("number", String.valueOf(regionNumber++));
            applidElement.setAttribute("id", cincState.getApp());
            rootElement.addElement(applidElement);
        }
        AtomContent atomContent = AtomContent.parse(rootElement, connectionId);
        Debug.exit((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"createAtomContentWithDetailsElement");
        return atomContent;
    }

    private static AtomContentElement createChildElement(CincUser cincUser, AtomContentElement rootElement, boolean updated) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        Debug.enter((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"createChildElement", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "cincUser nameId: " + (cincUser == null ? cincUser : cincUser.getNameid()), "rootElement: " + (rootElement == null ? rootElement : rootElement.getName()), "updated: " + updated});
        AtomContentElement childElement = new AtomContentElement();
        childElement.setName(updated ? "updated" : "cincuser");
        Field[] fieldArray = fields = CincUser.class.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.setAccessible(true);
            XmlAttribute xmlAttr = field.getAnnotation(XmlAttribute.class);
            if (xmlAttr != null && field.get(cincUser) != null) {
                childElement.setAttribute(xmlAttr.name(), field.get(cincUser).toString().trim());
            }
            ++n2;
        }
        rootElement.addElement(childElement);
        Debug.exit((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"createChildElement", (Object)("childElement: " + childElement.getName()));
        return childElement;
    }

    private static AtomContentElement createGroupElement(CIUAWSCFResponseProgramInterface.CfOutBuf cfOutBuf, AtomContentElement parentElement, boolean updated) throws IllegalArgumentException, IllegalAccessException {
        Debug.enter((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"createGroupElement", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "cfOutBuf applName: " + (cfOutBuf == null ? cfOutBuf : cfOutBuf.getApplName()), "parentElement: " + (parentElement == null ? parentElement : parentElement.getName()), "updated: " + updated});
        AtomContentElement groupElement = new AtomContentElement();
        groupElement.setName(updated ? "updated" : "group");
        groupElement.setAttribute("state", cfOutBuf.getState().trim());
        WebServiceRequest.addCommonAttributes(cfOutBuf, groupElement);
        groupElement.setAttribute("journalcc", cfOutBuf.getJournalcc().trim());
        groupElement.setAttribute("appl_mode", cfOutBuf.getApplMode().trim());
        groupElement.setAttribute("appl_name", cfOutBuf.getApplName().trim());
        groupElement.setAttribute("appl_ver1", cfOutBuf.getApplVer1().trim());
        groupElement.setAttribute("appl_ver2", cfOutBuf.getApplVer2().trim());
        groupElement.setAttribute("appl_ver3", cfOutBuf.getApplVer3().trim());
        groupElement.setAttribute("max_task", cfOutBuf.getMaxTask().trim());
        groupElement.setAttribute("max_recs", cfOutBuf.getMaxRecs().trim());
        groupElement.setAttribute("tran_exlist_name", cfOutBuf.getTranExlistName().trim());
        groupElement.setAttribute("prog_exlist_name", cfOutBuf.getProgExlistName().trim());
        groupElement.setAttribute("comm_inlist_name", cfOutBuf.getCommInlistName().trim());
        groupElement.setAttribute("kcics", cfOutBuf.getKcics().trim());
        groupElement.setAttribute("kyims", cfOutBuf.getKyims().trim());
        groupElement.setAttribute("keymq", cfOutBuf.getKeymq().trim());
        groupElement.setAttribute("kydb2", cfOutBuf.getKydb2().trim());
        groupElement.setAttribute("kynat", cfOutBuf.getKynat().trim());
        int regionNumber = 1;
        for (CIUAWSCFResponseProgramInterface.CfOutBuf.Cincstate cincState : cfOutBuf.getCincstates()) {
            AtomContentElement cincStateElement = new AtomContentElement();
            cincStateElement.setName("cincstate");
            cincStateElement.setAttribute("number", String.valueOf(regionNumber++));
            cincStateElement.setAttribute("app", cincState.getApp());
            cincStateElement.setAttribute("sysid", cincState.getSysid());
            cincStateElement.setAttribute("cf_total", cincState.getCfTotal());
            cincStateElement.setAttribute("curr_state", cincState.getCurrState());
            groupElement.addElement(cincStateElement);
        }
        parentElement.addElement(groupElement);
        Debug.exit((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"createGroupElement", (Object)("groupElement: " + groupElement));
        return groupElement;
    }

    private static void addCommonAttributes(CIUAWSCFResponseProgramInterface.CfOutBuf cfOutBuf, AtomContentElement element) {
        Debug.enter((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"addCommonAttributes", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "cfOutBuf applName: " + (cfOutBuf == null ? cfOutBuf : cfOutBuf.getApplName()), "element: " + (element == null ? element : element.getName())});
        element.setAttribute("nameid", cfOutBuf.getNameid().trim());
        element.setAttribute("datestart", cfOutBuf.getDatestart().trim());
        element.setAttribute("timestart", cfOutBuf.getTimestart().trim());
        element.setAttribute("datestop", cfOutBuf.getDatestop().trim());
        element.setAttribute("timestop", cfOutBuf.getTimestop().trim());
        element.setAttribute("tuserid", cfOutBuf.getTuserid().trim());
        element.setAttribute("cmdflowid", cfOutBuf.getCmdflowid().trim());
        element.setAttribute("authority", cfOutBuf.getAuthority().trim());
        element.setAttribute("termid", cfOutBuf.getTermid().trim());
        element.setAttribute("journal", cfOutBuf.getJournal().trim());
        element.setAttribute("exitname", cfOutBuf.getExitname().trim());
        element.setAttribute("dcall", cfOutBuf.getDcall().trim());
        element.setAttribute("tran1", cfOutBuf.getTran1().trim());
        element.setAttribute("tran2", cfOutBuf.getTran2().trim());
        element.setAttribute("tran3", cfOutBuf.getTran3().trim());
        element.setAttribute("tran4", cfOutBuf.getTran4().trim());
        element.setAttribute("tran5", cfOutBuf.getTran5().trim());
        Debug.exit((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"addCommonAttributes");
    }

    public static List<AtomContent> serviceResponseToAtomContents(CiuawsdaServiceResponse serviceResponse, String connectionId, boolean updated) throws IllegalAccessException {
        Debug.enter((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"serviceResponseToAtomContents", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "serviceResponse message: " + (serviceResponse == null ? serviceResponse : serviceResponse.getMessage()), "connectionId: " + connectionId, "updated: " + updated});
        ArrayList<AtomContent> atomContents = new ArrayList<AtomContent>();
        if (serviceResponse.getRegion() != null) {
            Region region = serviceResponse.getRegion();
            AtomContent atomContent = WebServiceRequest.createAtomContent(connectionId, region, updated);
            atomContents.add(atomContent);
        } else if (serviceResponse.getRegions() != null) {
            for (Region region : serviceResponse.getRegions().getRegions()) {
                AtomContent atomContent = WebServiceRequest.createAtomContent(connectionId, region, updated);
                atomContents.add(atomContent);
            }
        } else if (serviceResponse.getUsers() != null) {
            for (CincUser cincUser : serviceResponse.getUsers().getUsers()) {
                AtomContent atomContent = WebServiceRequest.createAtomContent(connectionId, cincUser, updated);
                atomContents.add(atomContent);
            }
        }
        Debug.exit((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"serviceResponseToAtomContents", (Object)("result size: " + atomContents.size()));
        return atomContents;
    }

    public static String showMessage(CiuawsdaServiceResponse.Message message) {
        Debug.enter((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"showMessage", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "message: " + message.toString()});
        ArrayList<String> paramList = new ArrayList<String>();
        for (CiuawsdaServiceResponse.Message.Params params : message.getParams()) {
            if (!IAUtilities.hasContent(params.getParam())) continue;
            paramList.add(params.getParam().trim());
        }
        String result = WebServiceRequest.showMessage(message.getMsgnum().trim(), paramList.toArray(new String[0]));
        Debug.exit((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"showMessage", (Object)("result: " + result));
        return result;
    }

    public static String showMessage(CIUAWSCFResponseProgramInterface.CfOutBuf.Message message) {
        Debug.enter((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"showMessage", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "message: " + message.toString()});
        ArrayList<String> paramList = new ArrayList<String>();
        for (CIUAWSCFResponseProgramInterface.CfOutBuf.Message.Params params : message.getParams()) {
            if (!IAUtilities.hasContent(params.getParam())) continue;
            paramList.add(params.getParam().trim());
        }
        String result = WebServiceRequest.showMessage(message.getMsgnum().trim(), paramList.toArray(new String[0]));
        Debug.exit((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"showMessage", (Object)("result: " + result));
        return result;
    }

    private static String showMessage(String messageNum, String ... params) {
        Debug.enter((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"showMessage", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "messageNum: " + messageNum, "params: " + params});
        String userMessage = "";
        ArrayList<String> args = new ArrayList<String>();
        if (params != null) {
            String[] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                if (IAUtilities.hasContent(param)) {
                    args.add(param);
                }
                ++n2;
            }
        }
        String messageCode = "CICSIA.Collector." + messageNum;
        userMessage = args.size() > 0 ? String.valueOf(messageNum) + ":" + " " + MessageFormat.format(Messages.getString(messageCode), args.toArray()) : String.valueOf(messageNum) + ":" + " " + Messages.getString(messageCode);
        if (AtomDefinitions.WARNING_MESSAGES.contains(messageNum) || AtomDefinitions.ERROR_MESSAGES.contains(messageNum) || AtomDefinitions.SEVERE_MESSAGES.contains(messageNum)) {
            ViewHelper.setDeferredStatusErrorMessage((String)userMessage);
            IAPlugin.getDefault().logError(userMessage, null);
        } else if (AtomDefinitions.INFO_MESSAGES.contains(messageNum)) {
            ViewHelper.setDeferredStatusInformationMessage((String)userMessage);
        } else {
            ViewHelper.setDeferredStatus((IStatus)Status.CANCEL_STATUS);
        }
        Debug.exit((Logger)logger, (String)WebServiceRequest.class.getName(), (String)"showMessage", (Object)("userMessage: " + userMessage));
        return userMessage;
    }

    public String getMessage() {
        return this.message;
    }
}

