/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Task;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Logger;

public class TransactionTasksCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TransactionTasksCommand.class.getPackage().getName());
    private Transaction transaction;

    public TransactionTasksCommand(Transaction aTransaction) {
        Debug.enter((Logger)logger, (String)TransactionTasksCommand.class.getName(), (String)"TransactionTasksCommand", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.transaction = aTransaction;
        this.setAsync(false);
        Debug.exit((Logger)logger, (String)TransactionTasksCommand.class.getName(), (String)"TransactionTasksCommand");
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)TransactionTasksCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String taskID = resultSet.getString(2).trim();
        String distributedUOW = resultSet.getString(3).trim();
        Timestamp commandTime = resultSet.getTimestamp(4);
        String applId = resultSet.getString(5).trim();
        Task task = new Task(this.transaction, taskID, distributedUOW, commandTime, null, applId);
        Debug.exit((Logger)logger, (String)TransactionTasksCommand.class.getName(), (String)"processRow");
        return task;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)TransactionTasksCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getCommandFlowTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("TRANSID", table, ColumnReference.DataType.String, null);
        result.getSelect().addSelectionColumn("TASKID", table, ColumnReference.DataType.String, null);
        result.getSelect().addSelectionColumn("DISTRIBUTED_UOW", table, ColumnReference.DataType.String, null);
        result.getSelect().addSelectionColumn("CMD_TIME_LOCAL", table, ColumnReference.DataType.Timestamp, null);
        result.getSelect().addSelectionColumn("APPLID", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.appendCondition("TRANSID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.transaction.getName()}, QueryElement.Predicate.AND, false);
        result.appendCondition("FUNCTION", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{"START OF TRANSACTION"}, QueryElement.Predicate.AND, false);
        Debug.exit((Logger)logger, (String)TransactionTasksCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

