/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.commands.TargetCommonInteractionForProgramCommand;
import com.ibm.cics.ia.model.Interaction;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class TargetCICSInteractionsForProgramCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TargetCICSInteractionsForProgramCommand.class.getPackage().getName());
    private Program program;
    private Transaction transaction;

    public TargetCICSInteractionsForProgramCommand(Program aProgram, Transaction aTransaction) {
        Debug.enter((Logger)logger, (String)TargetCICSInteractionsForProgramCommand.class.getName(), (String)"TargetCICSInteractionsForProgramCommand", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.program = aProgram;
        this.transaction = aTransaction;
        this.setAsync(false);
        this.setDescription("CICS Interactions for " + aProgram);
        Debug.exit((Logger)logger, (String)TargetCICSInteractionsForProgramCommand.class.getName(), (String)"TargetCICSInteractionsForProgramCommand");
    }

    public TargetCICSInteractionsForProgramCommand(Program aProgram) {
        this(aProgram, null);
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)TargetCICSInteractionsForProgramCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String applID = resultSet.getString(1);
        String verb = resultSet.getString(2).trim();
        String objectType = resultSet.getString(3);
        String objectID = resultSet.getString(4).trim();
        String remoteSysid = resultSet.getString(5).trim();
        String remoteName = resultSet.getString(6).trim();
        Region sourceRegion = ResourceFactory.getSingleton().getRegion(applID);
        Resource object = ResourceFactory.getSingleton().getResource(objectType, objectID);
        Interaction interaction = new Interaction(sourceRegion, this.program, verb, object, sourceRegion, remoteSysid, remoteName);
        Debug.exit((Logger)logger, (String)TargetCICSInteractionsForProgramCommand.class.getName(), (String)"processRow");
        return interaction;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)TargetCICSInteractionsForProgramCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getCICSDataTableName();
        SelectionObject result = TargetCommonInteractionForProgramCommand.getCommonSelectionObject(table, this.program, this.transaction);
        result.getSelection().getSelect().addSelectionColumn("RMTSYSID", table, ColumnReference.DataType.String, null);
        result.getSelection().getSelect().addSelectionColumn("RMTNAME", table, ColumnReference.DataType.String, null);
        ColumnReference column = PresentationFactory.getInstance().createBasicColumn("TYPE", table, ColumnReference.DataType.String);
        Clause constraint10 = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, new Object[]{"PROGRAM"}, true);
        ConstraintElement constraint11 = constraint10.appendCondition("FUNCTION", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{"INQUIRE"}, QueryElement.Predicate.OR, true);
        Clause constraint20 = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, new Object[]{"TRANSID"}, true);
        ConstraintElement constraint21 = constraint20.appendCondition("FUNCTION", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{"INQUIRE"}, QueryElement.Predicate.OR, true);
        ((Selection)result).appendCondition(constraint11, QueryElement.Predicate.AND);
        ((Selection)result).appendCondition(constraint21, QueryElement.Predicate.AND);
        Debug.exit((Logger)logger, (String)TargetCICSInteractionsForProgramCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

