/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.SourceTransactionInteractionsForResourceCommand;
import com.ibm.cics.ia.model.Interaction;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class SourceTransactionInteractionsForProgramCommand
extends SourceTransactionInteractionsForResourceCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(SourceTransactionInteractionsForProgramCommand.class.getPackage().getName());

    public SourceTransactionInteractionsForProgramCommand(Resource resource) {
        super(resource);
    }

    @Override
    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)SourceTransactionInteractionsForProgramCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String applID = resultSet.getString(1);
        String transID = resultSet.getString(2);
        String verb = IAUtilities.EMPTY_STRING;
        Transaction transaction = ResourceFactory.getSingleton().getTransaction(transID);
        Region sourceRegion = ResourceFactory.getSingleton().getRegion(applID);
        Interaction interaction = new Interaction(sourceRegion, transaction, verb, this.resource, sourceRegion);
        Debug.exit((Logger)logger, (String)SourceTransactionInteractionsForProgramCommand.class.getName(), (String)"processRow");
        return interaction;
    }

    @Override
    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)SourceTransactionInteractionsForProgramCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getCICSDataTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("APPLID", table, ColumnReference.DataType.String, null);
        result.getSelect().addSelectionColumn("TRANSID", table, ColumnReference.DataType.String, null);
        if (IAUtilities.hasContent(collectionId)) {
            result.appendCondition("COLLECTION_ID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        result.appendCondition("PROGRAM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getName()}, QueryElement.Predicate.AND, false);
        ColumnReference column = PresentationFactory.getInstance().createBasicColumn("TYPE", table, ColumnReference.DataType.String);
        Clause constraint10 = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, new Object[]{"PROGRAM"}, true);
        ConstraintElement constraint11 = constraint10.appendCondition("FUNCTION", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{"INQUIRE"}, QueryElement.Predicate.OR, true);
        Clause constraint20 = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, new Object[]{"TRANSID"}, true);
        ConstraintElement constraint21 = constraint20.appendCondition("FUNCTION", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{"INQUIRE"}, QueryElement.Predicate.OR, true);
        result.appendCondition(constraint11, QueryElement.Predicate.AND);
        result.appendCondition(constraint21, QueryElement.Predicate.AND);
        Debug.exit((Logger)logger, (String)SourceTransactionInteractionsForProgramCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

