/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.SourceTransactionInteractionsForResourceCommand;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.logging.Logger;

public class SourceTransactionInteractionsForDB2ResourceCommand
extends SourceTransactionInteractionsForResourceCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(SourceTransactionInteractionsForDB2ResourceCommand.class.getPackage().getName());

    public SourceTransactionInteractionsForDB2ResourceCommand(Resource aResource) {
        super(aResource);
    }

    @Override
    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)SourceTransactionInteractionsForDB2ResourceCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getDB2DataTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("APPLID", table, ColumnReference.DataType.String, null);
        result.getSelect().addSelectionColumn("TRANSID", table, ColumnReference.DataType.String, null);
        result.getSelect().addSelectionColumn("FUNCTION", table, ColumnReference.DataType.String, null);
        if (IAUtilities.hasContent(collectionId)) {
            result.appendCondition("COLLECTION_ID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        result.appendCondition("RESTYPE", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getTypeName()}, QueryElement.Predicate.AND, false);
        result.appendCondition("RESNAME", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getName()}, QueryElement.Predicate.AND, false);
        Debug.exit((Logger)logger, (String)SourceTransactionInteractionsForDB2ResourceCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

