/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.IAApplication;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class ResourceVisualizationByIACommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ResourceVisualizationByIACommand.class.getPackage().getName());
    private Resource resource;

    public ResourceVisualizationByIACommand(Resource aResource) {
        this.resource = aResource;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)ResourceVisualizationByIACommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IAApplication application = ResourceFactory.getSingleton().getIAApplication(resultSet.getString(1).trim(), null);
        Resource resource = ResourceFactory.getSingleton().getResource(resultSet.getString(2).trim(), resultSet.getString(3).trim());
        Debug.exit((Logger)logger, (String)ResourceVisualizationByIACommand.class.getName(), (String)"processRow");
        return new Resource[]{application, resource};
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)ResourceVisualizationByIACommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getApplicationResourcesTableName();
        Selection selection = PresentationFactory.getInstance().createSelectForTable(table, null);
        selection.getSelect().setDistinct(true);
        selection.getSelect().addSelectionColumn("APPLIC_CODE", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("APPLIC_TYPE", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("APPLIC_RESNAME", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        if (this.resource != null) {
            if (this.resource instanceof IAApplication) {
                selection.appendCondition("APPLIC_CODE", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getName()}, QueryElement.Predicate.AND, false);
            } else {
                selection.appendCondition("APPLIC_TYPE", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getTypeName()}, QueryElement.Predicate.AND, false);
                selection.appendCondition("APPLIC_RESNAME", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getName()}, QueryElement.Predicate.AND, false);
            }
        }
        if (IAUtilities.hasContent(collectionId)) {
            selection.appendCondition("COLLECTION_ID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        Debug.exit((Logger)logger, (String)ResourceVisualizationByIACommand.class.getName(), (String)"getSelectionObject");
        return selection;
    }
}

