/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class ResourceConnectionsCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ResourceConnectionsCommand.class.getPackage().getName());
    protected List<Resource> sources;
    protected Region region;
    protected Platform platform;
    protected TSApplication tsApplication;
    protected Transaction scopingTransaction;

    public ResourceConnectionsCommand(List<Resource> sources, Region region, Platform platform, TSApplication tsApplication, Transaction scopingTransaction) {
        this.sources = sources;
        this.region = region;
        this.tsApplication = tsApplication;
        this.platform = platform;
        this.scopingTransaction = scopingTransaction;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)ResourceConnectionsCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int pos = 1;
        Region region = ResourceFactory.getSingleton().getRegion(resultSet.getString(pos++).trim());
        TSApplication application = null;
        Platform platform = null;
        if (Version.getInstance().getDBVersion() >= 5100) {
            if (Version.getInstance().getDBVersion() >= 5200) {
                String platformName = resultSet.getString(pos++).trim();
                platform = ResourceFactory.getSingleton().getPlatform(platformName);
            }
            String applName = resultSet.getString(pos++).trim();
            int applVer1 = 0;
            int applVer2 = 0;
            int applVer3 = 0;
            if (IAUtilities.hasContent(applName)) {
                applVer1 = resultSet.getInt(pos++);
                applVer2 = resultSet.getInt(pos++);
                applVer3 = resultSet.getInt(pos++);
            } else {
                pos += 3;
            }
            application = ResourceFactory.getSingleton().getTSApplication(platform, applName, applVer1, applVer2, applVer3);
        }
        Transaction transaction = ResourceFactory.getSingleton().getTransaction(resultSet.getString(pos++).trim());
        Program program = ResourceFactory.getSingleton().getProgram(resultSet.getString(pos++).trim());
        Resource resource = ResourceFactory.getSingleton().getResource(resultSet.getString(pos++).trim(), resultSet.getString(pos++).trim());
        String verb = resultSet.getString(pos++).trim();
        Object[] row = new Object[]{region, platform, application, transaction, program, resource, verb};
        Debug.exit((Logger)logger, (String)ResourceConnectionsCommand.class.getName(), (String)"processRow");
        return row;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)ResourceConnectionsCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = this.getTableName();
        Selection selection = PresentationFactory.getInstance().createSelectForTable(table, null);
        selection.getSelect().setDistinct(true);
        selection.getSelect().addSelectionColumn("APPLID", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        if (Version.getInstance().getDBVersion() >= 5100) {
            if (Version.getInstance().getDBVersion() >= 5200) {
                selection.getSelect().addSelectionColumn("PLATFORM", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
            }
            selection.getSelect().addSelectionColumn("APPL_NAME", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
            selection.getSelect().addSelectionColumn("APPL_VER1", table, ColumnReference.DataType.Integer, ColumnReference.Function.NONE);
            selection.getSelect().addSelectionColumn("APPL_VER2", table, ColumnReference.DataType.Integer, ColumnReference.Function.NONE);
            selection.getSelect().addSelectionColumn("APPL_VER3", table, ColumnReference.DataType.Integer, ColumnReference.Function.NONE);
        }
        selection.getSelect().addSelectionColumn("TRANSID", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("PROGRAM", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("TYPE", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("OBJECT", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("FUNCTION", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        if (this.region != null) {
            selection.appendCondition("APPLID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.region.getName()}, QueryElement.Predicate.AND, false);
        }
        if (this.platform != null) {
            selection.appendCondition("PLATFORM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.platform.getName()}, QueryElement.Predicate.AND, false);
        }
        if (this.tsApplication != null) {
            selection.appendCondition("APPL_NAME", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.tsApplication.getName()}, QueryElement.Predicate.AND, false);
            selection.appendCondition("APPL_VER1", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{this.tsApplication.getMajorVersion()}, QueryElement.Predicate.AND, false);
            selection.appendCondition("APPL_VER2", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{this.tsApplication.getMinorVersion()}, QueryElement.Predicate.AND, false);
            selection.appendCondition("APPL_VER3", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{this.tsApplication.getMicroVersion()}, QueryElement.Predicate.AND, false);
        }
        if (this.scopingTransaction != null) {
            selection.appendCondition("TRANSID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.scopingTransaction.getName()}, QueryElement.Predicate.AND, false);
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Resource resource : this.sources) {
            names.add(resource.getName());
        }
        if (this.sources != null && this.sources.size() > 0 && this.sources.get(0).getTypeName().equals("PROGRAM")) {
            selection.appendCondition("PROGRAM", table, ColumnReference.DataType.String, Comparator.IN, names.toArray(), QueryElement.Predicate.AND, false);
        } else if (this.sources != null && this.sources.size() > 0 && this.sources.get(0).getTypeName().equals("TRANSID")) {
            selection.appendCondition("TRANSID", table, ColumnReference.DataType.String, Comparator.IN, names.toArray(), QueryElement.Predicate.AND, false);
        }
        selection.appendCondition("TYPE", table, ColumnReference.DataType.String, Comparator.IN, new Object[]{"PROGRAM", "TRANSID"}, QueryElement.Predicate.AND, false);
        if (IAUtilities.hasContent(collectionId)) {
            selection.appendCondition("COLLECTION_ID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        Debug.exit((Logger)logger, (String)ResourceConnectionsCommand.class.getName(), (String)"getSelectionObject");
        return selection;
    }

    public abstract String getTableName();
}

