/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.FindApplicationsUsingResourceCommand;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.commands.Messages;
import com.ibm.cics.ia.commands.ProgramResourceCICSConnectionsCommand;
import com.ibm.cics.ia.commands.ProgramResourceDB2ConnectionsCommand;
import com.ibm.cics.ia.commands.ProgramResourceIMSConnectionsCommand;
import com.ibm.cics.ia.commands.ProgramResourceMQConnectionsCommand;
import com.ibm.cics.ia.commands.ResourceCICSConnectionsCommand;
import com.ibm.cics.ia.commands.ResourceConnectionsInitialProgramsCommand;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.viz.IConnectionsAnalyzerListener;
import com.ibm.cics.ia.model.viz.INestedNode;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.model.viz.NestedNode;
import com.ibm.cics.ia.model.viz.Node;
import com.ibm.cics.ia.model.viz.NodeConnection;
import com.ibm.cics.ia.model.viz.ProgramNode;
import com.ibm.cics.ia.model.viz.ResourceFilter;
import com.ibm.cics.ia.model.viz.RootNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ResourceConnectionsAnalyzer
extends Job {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ResourceConnectionsAnalyzer.class.getPackage().getName());
    Resource root;
    LinkedList<Resource> searchQueue = new LinkedList();
    RootNode rootNode;
    HashSet<Resource> completedResources = new HashSet();
    LinkedList<IConnectionsAnalyzerListener> listeners = new LinkedList();
    private Region contextRegion;
    private Platform contextPlatform;
    private TSApplication contextApplication;
    private Transaction contextTransaction;
    private String taskName;
    private boolean cancelled = false;
    private String INIT = "INIT";
    private boolean groupByRegions = false;
    private boolean groupByApplications = false;
    private boolean groupByPlatforms = false;

    public ResourceConnectionsAnalyzer(Resource rootResource, Region contextRegion, Platform contextPlatform, TSApplication contextApplication, Transaction contextTransaction, boolean groupByRegions, boolean groupByPlatforms, boolean groupByApplications) {
        super(MessageFormat.format(Messages.getString("ResourceConnectionsAnalyzer.taskName.text"), rootResource.toString()));
        this.root = rootResource;
        this.searchQueue.add(this.root);
        this.rootNode = new RootNode();
        this.contextRegion = contextRegion;
        this.contextPlatform = contextPlatform;
        this.contextApplication = contextApplication;
        this.rootNode.setData("CONTEXT_REGION", contextRegion);
        this.rootNode.setData("CONTEXT_PLATFORM", contextPlatform);
        this.rootNode.setData("CONTEXT_APPLICATION", contextApplication);
        this.groupByRegions = groupByRegions;
        this.groupByApplications = groupByApplications;
        this.groupByPlatforms = groupByPlatforms;
        this.contextTransaction = contextTransaction;
    }

    public void start() {
        Debug.enter((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"start", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.root instanceof Program) {
            this.createInitialProgramNode((Program)this.root);
        }
        this.search();
        Debug.exit((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"start");
    }

    public void findOutgoingConnections(INode transactionNode) {
        Transaction transaction = (Transaction)transactionNode.getObject();
        if (!this.completedResources.contains(transaction)) {
            this.contextTransaction = transaction;
            this.searchQueue.add(transaction);
            this.search();
            this.notifyListeners();
        }
    }

    private void search() {
        while (!this.searchQueue.isEmpty() && !this.cancelled) {
            Resource currentResource;
            Iterator iter = this.searchQueue.iterator();
            ArrayList<Resource> programs = new ArrayList<Resource>();
            while (iter.hasNext() && programs.size() < 2000) {
                currentResource = (Resource)iter.next();
                if (!(currentResource instanceof Program)) continue;
                programs.add(currentResource);
                iter.remove();
            }
            if (programs.size() > 0) {
                this.getProgramConnections(programs);
                this.completedResources.addAll(programs);
            } else if (this.searchQueue.size() > 0) {
                currentResource = this.searchQueue.getFirst();
                if (currentResource instanceof Transaction) {
                    this.analyzeTransactionConnections((Transaction)currentResource);
                    this.completedResources.add(currentResource);
                }
                this.searchQueue.removeFirst();
            }
            this.notifyListeners();
        }
    }

    private void createInitialProgramNode(Program program) {
        if (this.groupByRegions || this.groupByPlatforms || this.groupByApplications) {
            ResourceConnectionsInitialProgramsCommand command = new ResourceConnectionsInitialProgramsCommand(program, this.groupByRegions, this.groupByPlatforms, this.groupByApplications);
            IASQLCommand.runCommandSynch(command);
            while (command.status() == 3) {
                command.resume();
            }
            if (command.getResults() == null) {
                return;
            }
            List results = command.getResults();
            for (Object[] row : results) {
                Region region = this.groupByRegions ? (Region)row[0] : this.contextRegion;
                Platform platform = this.groupByPlatforms ? (Platform)row[1] : this.contextPlatform;
                TSApplication application = this.groupByApplications ? (TSApplication)row[2] : this.contextApplication;
                INode iNode = this.addResourceNode(program, region, platform, application);
            }
        } else {
            INode iNode = this.addResourceNode(program, this.contextRegion, this.contextPlatform, this.contextApplication);
        }
    }

    public void findResources(List<String> resources, String resourceCategory) {
        List programs = this.rootNode.getAll(new Program(""));
        NestedNode<Region> dummyRegionNode = new NestedNode<Region>();
        if (!this.groupByRegions && this.contextRegion != null) {
            dummyRegionNode.setObject(this.contextRegion);
        }
        NestedNode<Platform> dummyPlatformNode = new NestedNode<Platform>();
        if (!this.groupByPlatforms && this.contextPlatform != null) {
            dummyPlatformNode.setObject(this.contextPlatform);
        }
        NestedNode<TSApplication> dummyApplciationNode = new NestedNode<TSApplication>();
        if (!this.groupByApplications && this.contextApplication != null) {
            dummyApplciationNode.setObject(this.contextApplication);
        }
        HashMap regionToPlatformNodes = new HashMap();
        HashMap platformToApplicationNodes = new HashMap();
        HashMap applicationToProgramNodes = new HashMap();
        for (INode programNode : programs) {
            ArrayList platformNodeList;
            INestedNode parent = programNode.getParent();
            INestedNode parentApplicationNode = null;
            INestedNode parentPlatformNode = null;
            INestedNode parentRegionNode = null;
            if (parent.getObject() != null && parent.getObject() instanceof TSApplication) {
                parentApplicationNode = parent;
                parent = parentApplicationNode.getParent();
            } else {
                parentApplicationNode = dummyApplciationNode;
            }
            if (parent.getObject() != null && parent.getObject() instanceof Platform) {
                parentPlatformNode = parent;
                parent = parentPlatformNode.getParent();
            } else {
                parentPlatformNode = dummyPlatformNode;
            }
            if (parent.getObject() != null && parent.getObject() instanceof Region) {
                parentRegionNode = parent;
                parent = parentRegionNode.getParent();
            } else {
                parentRegionNode = dummyRegionNode;
            }
            ArrayList<Node> programNodeList = (ArrayList<Node>)applicationToProgramNodes.get(parentApplicationNode);
            if (programNodeList == null) {
                programNodeList = new ArrayList<Node>();
                applicationToProgramNodes.put(parentApplicationNode, programNodeList);
            }
            programNodeList.add((Node)programNode);
            ArrayList applicationNodeList = (ArrayList)platformToApplicationNodes.get(parentPlatformNode);
            if (applicationNodeList == null) {
                applicationNodeList = new ArrayList();
                platformToApplicationNodes.put(parentPlatformNode, applicationNodeList);
            }
            if (!applicationNodeList.contains(parentApplicationNode)) {
                applicationNodeList.add(parentApplicationNode);
            }
            if ((platformNodeList = (ArrayList)regionToPlatformNodes.get(parentRegionNode)) == null) {
                platformNodeList = new ArrayList();
                regionToPlatformNodes.put(parentRegionNode, platformNodeList);
            }
            if (platformNodeList.contains(parentPlatformNode)) continue;
            platformNodeList.add(parentPlatformNode);
        }
        if (resources != null && resourceCategory != null) {
            for (INestedNode regionNode : regionToPlatformNodes.keySet()) {
                List platformNodes = (List)regionToPlatformNodes.get(regionNode);
                for (INestedNode platformNode : platformNodes) {
                    List applicationNodes = (List)platformToApplicationNodes.get(platformNode);
                    for (INestedNode applicationNode : applicationNodes) {
                        ArrayList programNodes = (ArrayList)applicationToProgramNodes.get(applicationNode);
                        ArrayList<Node<Program>> programSubList = new ArrayList<Node<Program>>();
                        int i = 0;
                        while (i < programNodes.size()) {
                            programSubList.add((Node)programNodes.get(i));
                            if (i > 0 && i % 1000 == 0) {
                                this.getProgramResourcesFor(regionNode, platformNode, applicationNode, programSubList, resources, resourceCategory);
                                programSubList.clear();
                            }
                            ++i;
                        }
                        if (programSubList.size() <= 0) continue;
                        this.getProgramResourcesFor(regionNode, platformNode, applicationNode, programSubList, resources, resourceCategory);
                    }
                }
            }
        }
        this.notifyListeners();
    }

    /*
     * WARNING - void declaration
     */
    public void getProgramResourcesFor(INestedNode<Region> regionNode, INestedNode<Platform> platformNode, INestedNode<TSApplication> applicationNode, List<Node<Program>> programNodes, List<String> resources, String resourceCategory) {
        void var11_17;
        Region region = (Region)regionNode.getObject();
        Platform platform = (Platform)platformNode.getObject();
        TSApplication application = (TSApplication)applicationNode.getObject();
        ArrayList<Program> programs = new ArrayList<Program>();
        for (INode iNode : programNodes) {
            programs.add((Program)iNode.getObject());
        }
        if (ResourceFilter.CICS.equals(resourceCategory)) {
            ProgramResourceCICSConnectionsCommand programResourceCICSConnectionsCommand = new ProgramResourceCICSConnectionsCommand(region, platform, application, programs, resources);
        } else if (ResourceFilter.DB2.equals(resourceCategory)) {
            ProgramResourceDB2ConnectionsCommand programResourceDB2ConnectionsCommand = new ProgramResourceDB2ConnectionsCommand(region, platform, application, programs, resources);
        } else if (ResourceFilter.IMS.equals(resourceCategory)) {
            ProgramResourceIMSConnectionsCommand programResourceIMSConnectionsCommand = new ProgramResourceIMSConnectionsCommand(region, platform, application, programs, resources);
        } else if (ResourceFilter.MQ.equals(resourceCategory)) {
            ProgramResourceMQConnectionsCommand programResourceMQConnectionsCommand = new ProgramResourceMQConnectionsCommand(region, platform, application, programs, resources);
        } else {
            return;
        }
        var11_17.setAsync(false);
        var11_17.start();
        List results = var11_17.getResults();
        for (Object[] row : results) {
            Program program = (Program)row[0];
            Resource resource = (Resource)row[1];
            String verb = (String)row[2];
            INode sourceNode = this.addResourceNode(program, region, platform, application);
            INode targetNode = this.addResourceNode(resource, region, platform, application);
            this.addConnection(sourceNode, targetNode, verb);
        }
    }

    public void getProgramConnections(List<Resource> programs) {
        Debug.enter((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"analyzeProgramCICSConnections", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ResourceCICSConnectionsCommand connectionsCommand = new ResourceCICSConnectionsCommand(programs, this.contextRegion, this.contextPlatform, this.contextApplication, this.contextTransaction);
        IASQLCommand.runCommandSynch(connectionsCommand);
        while (connectionsCommand.status() == 3) {
            connectionsCommand.resume();
        }
        if (connectionsCommand.getResults() == null) {
            return;
        }
        List results = connectionsCommand.getResults();
        for (Object[] row : results) {
            Region region = this.groupByRegions ? (Region)row[0] : this.contextRegion;
            Platform platform = this.groupByPlatforms ? (Platform)row[1] : this.contextPlatform;
            TSApplication application = this.groupByApplications ? (TSApplication)row[2] : this.contextApplication;
            Resource source = (Resource)row[4];
            Resource target = (Resource)row[5];
            String verb = (String)row[6];
            INode sourceNode = this.addResourceNode(source, region, platform, application);
            INode targetNode = this.addResourceNode(target, region, platform, application);
            this.addConnection(sourceNode, targetNode, verb);
            if (!(target instanceof Program) || this.completedResources.contains(target) || this.searchQueue.contains(target)) continue;
            this.searchQueue.addLast(target);
        }
        Debug.exit((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"analyzeProgramCICSConnections");
    }

    public void analyzeTransactionConnections(Transaction transaction) {
        Debug.enter((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"analyzeTransactionConnections", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!transaction.equals(this.contextTransaction)) {
            return;
        }
        List<Resource[]> initialPgmsByRegionsAndApps = transaction.getFirstProgramsByRegionPlatformAndApplication(this.contextRegion, this.contextPlatform, this.contextApplication);
        for (Resource[] row : initialPgmsByRegionsAndApps) {
            Region region = this.groupByRegions ? (Region)row[0] : this.contextRegion;
            Platform platform = this.groupByPlatforms ? (Platform)row[1] : this.contextPlatform;
            TSApplication application = this.groupByApplications ? (TSApplication)row[2] : this.contextApplication;
            this.createInitialProgramConnection(region, platform, application, transaction, (Program)row[3]);
        }
        Debug.exit((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"analyzeTransactionConnections");
    }

    public void getProgramsUsedByTransaction(Transaction transaction, Region region, Platform platform, TSApplication application) {
        Debug.enter((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"getProgramsUsedByTransaction", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ArrayList<Resource> sources = new ArrayList<Resource>();
        sources.add(transaction);
        ResourceCICSConnectionsCommand connectionsCommand = new ResourceCICSConnectionsCommand(sources, region, platform, application, null);
        IASQLCommand.runCommandSynch(connectionsCommand);
        while (connectionsCommand.status() == 3) {
            connectionsCommand.resume();
        }
        if (connectionsCommand.getResults() == null) {
            return;
        }
        List results = connectionsCommand.getResults();
        for (Object[] row : results) {
            region = this.groupByRegions ? (Region)row[0] : this.contextRegion;
            platform = this.groupByPlatforms ? (Platform)row[1] : this.contextPlatform;
            application = this.groupByApplications ? (TSApplication)row[2] : this.contextApplication;
            Resource target = (Resource)row[5];
            INode sourceNode = this.addResourceNode(transaction, region, platform, application);
            INode targetNode = this.addResourceNode(target, region, platform, application);
            this.addConnection(sourceNode, targetNode, "");
            if (!(target instanceof Program) && !(target instanceof Transaction) || this.completedResources.contains(target) || this.searchQueue.contains(target)) continue;
            this.searchQueue.addLast(target);
        }
        Debug.exit((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"getProgramsUsedByTransaction");
    }

    public void createInitialProgramConnection(Region region, Platform platform, TSApplication application, Transaction transaction, Program program) {
        Debug.enter((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"createInitialProgramConnection", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (platform == null && application != null) {
            platform = application.getPlatform();
        }
        if (region == null && !this.groupByRegions) {
            region = this.contextRegion;
        }
        if (platform == null && !this.groupByPlatforms) {
            platform = this.contextPlatform;
        }
        if (application == null && !this.groupByApplications) {
            application = this.contextApplication;
        }
        INode sourceNode = this.addResourceNode(transaction, region, platform, application);
        INode targetNode = this.addResourceNode(program, region, platform, application);
        this.addConnection(sourceNode, targetNode, this.INIT);
        ((ProgramNode)targetNode).setFirst();
        if (!this.completedResources.contains(program) && !this.searchQueue.contains(program)) {
            this.searchQueue.addLast(program);
        }
        Debug.exit((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"createInitialProgramConnection");
    }

    public RootNode getRootNode() {
        return this.rootNode;
    }

    private INode addResourceNode(Resource resource, Region region, Platform platform, TSApplication application) {
        Debug.enter((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"addResourceNode", (Object)("Thread ID: " + Thread.currentThread().getId()));
        NestedNode<Region> regionNode = null;
        NestedNode<Platform> platformNode = null;
        NestedNode<TSApplication> applicationNode = null;
        Node resourceNode = null;
        INestedNode parentNode = this.rootNode;
        if (region != null) {
            regionNode = (NestedNode<Region>)parentNode.getChildren().get(region);
            if (regionNode == null) {
                regionNode = new NestedNode<Region>();
                regionNode.setObject(region);
                regionNode.setParent(parentNode);
                parentNode.getChildren().put(region, regionNode);
            }
            parentNode = regionNode;
        }
        if (platform != null) {
            platformNode = (NestedNode<Platform>)parentNode.getChildren().get(platform);
            if (platformNode == null) {
                platformNode = new NestedNode<Platform>();
                platformNode.setObject(platform);
                platformNode.setParent(parentNode);
                parentNode.getChildren().put(platform, platformNode);
            }
            parentNode = platformNode;
        }
        if (application != null) {
            applicationNode = (NestedNode<TSApplication>)parentNode.getChildren().get(application);
            if (applicationNode == null) {
                applicationNode = new NestedNode<TSApplication>();
                applicationNode.setObject(application);
                applicationNode.setParent(parentNode);
                parentNode.getChildren().put(application, applicationNode);
            }
            parentNode = applicationNode;
        }
        if (resource != null && (resourceNode = (Node)parentNode.getChildren().get(resource)) == null) {
            resourceNode = resource instanceof Program ? new ProgramNode() : new Node();
            resourceNode.setObject(resource);
            resourceNode.setParent(parentNode);
            parentNode.getChildren().put(resource, resourceNode);
        }
        Debug.exit((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"addResourceNode");
        return resourceNode;
    }

    private List<Resource[]> findApplications(Resource resource) {
        Debug.enter((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"findApplications", (Object)("Thread ID: " + Thread.currentThread().getId()));
        LinkedList<Resource[]> applications = new LinkedList<Resource[]>();
        FindApplicationsUsingResourceCommand findAppsCommand = new FindApplicationsUsingResourceCommand(null, resource);
        IASQLCommand.runCommandSynch(findAppsCommand);
        while (findAppsCommand.status() == 3) {
            findAppsCommand.resume();
        }
        List results = findAppsCommand.getResults();
        for (Object[] row : results) {
            if (row[2] == null) continue;
            applications.add(new Resource[]{(Region)row[0], (Platform)row[1], (TSApplication)row[2]});
        }
        Debug.exit((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"findApplications");
        return applications;
    }

    private void addConnection(INode sourceNode, INode targetNode, String verb) {
        Debug.enter((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"addConnection", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (sourceNode == null || targetNode == null) {
            return;
        }
        if (sourceNode != targetNode) {
            ArrayList<String> verbs;
            List<NodeConnection> outgoingConnections = sourceNode.getOutgoingConnections();
            List<NodeConnection> incomingConnections = targetNode.getIncomingConnections();
            NodeConnection existingConnection = null;
            for (NodeConnection resourceNodeConnection : incomingConnections) {
                if (!resourceNodeConnection.getSource().equals(sourceNode) || !resourceNodeConnection.getTarget().equals(targetNode)) continue;
                existingConnection = resourceNodeConnection;
                break;
            }
            if (existingConnection == null) {
                existingConnection = new NodeConnection(sourceNode, targetNode);
                incomingConnections.add(existingConnection);
                outgoingConnections.add(existingConnection);
            }
            if (!(verbs = existingConnection.getVerbs()).contains(verb)) {
                verbs.add(verb);
            }
        }
        Debug.exit((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"addConnection");
    }

    protected IStatus run(IProgressMonitor monitor) {
        Debug.enter((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        monitor.beginTask(this.taskName, -1);
        this.start();
        monitor.done();
        Debug.exit((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"run");
        return Status.OK_STATUS;
    }

    public void canceling() {
        this.cancelled = true;
        super.canceling();
    }

    public void addListener(IConnectionsAnalyzerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IConnectionsAnalyzerListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners() {
        Debug.enter((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"notifyListeners", (Object)("Thread ID: " + Thread.currentThread().getId()));
        for (IConnectionsAnalyzerListener listener : this.listeners) {
            listener.onRootNodeUpdated(this.rootNode);
        }
        Debug.exit((Logger)logger, (String)ResourceConnectionsAnalyzer.class.getName(), (String)"notifyListeners");
    }
}

