/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.ResourceConnectionsCommand;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.List;

public class ResourceCICSConnectionsCommand
extends ResourceConnectionsCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ResourceCICSConnectionsCommand(List<Resource> sources, Region region, Platform platform, TSApplication tsApplication, Transaction scopingTransaction) {
        super(sources, region, platform, tsApplication, scopingTransaction);
    }

    @Override
    public String getTableName() {
        return IAUtilities.getCICSDataTableName();
    }

    @Override
    public SelectionObject getSelectionObject() {
        Selection selection = (Selection)super.getSelectionObject();
        String table = this.getTableName();
        ColumnReference column = PresentationFactory.getInstance().createBasicColumn("TYPE", table, ColumnReference.DataType.String);
        Clause constraint10 = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, new Object[]{"PROGRAM"}, true);
        ConstraintElement constraint11 = constraint10.appendCondition("FUNCTION", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{"INQUIRE"}, QueryElement.Predicate.OR, true);
        Clause constraint20 = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, new Object[]{"TRANSID"}, true);
        ConstraintElement constraint21 = constraint20.appendCondition("FUNCTION", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{"INQUIRE"}, QueryElement.Predicate.OR, true);
        selection.appendCondition(constraint11, QueryElement.Predicate.AND);
        selection.appendCondition(constraint21, QueryElement.Predicate.AND);
        return selection;
    }
}

