/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.ia.commands.IColumnResultsCommand;
import com.ibm.cics.ia.commands.IQueryCommand;
import com.ibm.cics.ia.query.QueryResultRow;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class QueryDifferenceCommand
extends Command
implements IColumnResultsCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(QueryDifferenceCommand.class.getPackage().getName());
    private List inCommands = new ArrayList();
    private List notInCommands = new ArrayList();

    protected Object processRow(ResultSet resultSet) {
        return null;
    }

    public Collection getInCommands() {
        return this.inCommands;
    }

    public Collection getNotInCommands() {
        return this.notInCommands;
    }

    @Override
    public String[] getColumns() {
        Command firstNotInCommand;
        Command firstInCommand;
        Debug.enter((Logger)logger, (String)QueryDifferenceCommand.class.getName(), (String)"getColumns", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Iterator iterator = null;
        if (this.inCommands != null && (iterator = this.inCommands.iterator()).hasNext() && (firstInCommand = (Command)iterator.next()) instanceof IQueryCommand) {
            return ((IQueryCommand)firstInCommand).getColumns();
        }
        if (this.notInCommands != null && (iterator = this.notInCommands.iterator()).hasNext() && (firstNotInCommand = (Command)iterator.next()) instanceof IQueryCommand) {
            return ((IQueryCommand)firstNotInCommand).getColumns();
        }
        Debug.exit((Logger)logger, (String)QueryDifferenceCommand.class.getName(), (String)"getColumns");
        return new String[0];
    }

    public void start() {
        Debug.enter((Logger)logger, (String)QueryDifferenceCommand.class.getName(), (String)"start", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ArrayList in = new ArrayList();
        for (Command inCommand : this.inCommands) {
            in.addAll(inCommand.getResults());
        }
        List uniqueIn = IAUtilities.asUniqueCollection(in);
        for (Command notInCommand : this.notInCommands) {
            uniqueIn = QueryResultRow.inFirstListNotInSecond(uniqueIn, notInCommand.getResults());
        }
        this.getResults().addAll(uniqueIn);
        this.status = 1;
        Debug.exit((Logger)logger, (String)QueryDifferenceCommand.class.getName(), (String)"start");
    }
}

