/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.commands.IQueryCommand;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.model.Task;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.query.QueryResultRow;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class QueryCommand
extends IASQLCommand
implements IQueryCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(QueryCommand.class.getPackage().getName());
    private Presentation presentationObject;
    private ArrayList<ColumnReference> orderByColumns = new ArrayList();
    private boolean saveable = true;
    private String collectionIdAtRuntime = null;

    public QueryCommand(Presentation aPresentation) {
        this.presentationObject = aPresentation;
        this.orderByColumns.addAll(this.presentationObject.getSelection().getOrderBy().getColumns());
    }

    public void setPresentation(Presentation aPresentation) {
        this.presentationObject = aPresentation;
    }

    @Override
    public Presentation getQuery() {
        return this.presentationObject;
    }

    public boolean isSaveable() {
        return this.saveable;
    }

    public void setSaveable(boolean isSaveable) {
        this.saveable = isSaveable;
    }

    public String getCollectionIdAtRuntime() {
        return this.collectionIdAtRuntime;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)QueryCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        QueryResultRow row = new QueryResultRow();
        int columnCount = this.orderByColumns.size();
        Object[] rowData = new Object[columnCount];
        int j = 0;
        int transactionIndex = -1;
        List columnsToInclude = null;
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnReference column : this.orderByColumns) {
            columnNames.add(column.getColumnName());
        }
        int i = 0;
        while (i < columnNames.size()) {
            String name;
            Resource resource;
            String typeName;
            String objectName;
            String columnName = (String)columnNames.get(i);
            if (columnName.equals("APPL_NAME") || columnName.equals("APP_NAME")) {
                String applName = resultSet.getString(columnName).trim();
                if (applName.isEmpty()) {
                    Debug.exit((Logger)logger, (String)QueryCommand.class.getName(), (String)"processRow", (Object)"return null");
                    return null;
                }
                if (columnNames.contains("APPL_VER1") && columnNames.contains("APPL_VER2") && columnNames.contains("APPL_VER3") || columnNames.contains("APP_VER1") && columnNames.contains("APP_VER2") && columnNames.contains("APP_VER3")) {
                    rowData[j++] = applName;
                } else {
                    String platformName = null;
                    Integer majorVersion = null;
                    Integer minorVersion = null;
                    Integer microVersion = null;
                    if (this.attemptColumnFetch(resultSet, "PLATFORM") != null) {
                        platformName = resultSet.getString("PLATFORM");
                    }
                    if (this.attemptColumnFetch(resultSet, "APPL_VER1") != null) {
                        majorVersion = resultSet.getInt("APPL_VER1");
                    } else if (this.attemptColumnFetch(resultSet, "APP_VER1") != null) {
                        majorVersion = resultSet.getInt("APP_VER1");
                    }
                    if (this.attemptColumnFetch(resultSet, "APPL_VER2") != null) {
                        minorVersion = resultSet.getInt("APPL_VER2");
                    } else if (this.attemptColumnFetch(resultSet, "APP_VER2") != null) {
                        minorVersion = resultSet.getInt("APP_VER2");
                    }
                    if (this.attemptColumnFetch(resultSet, "APPL_VER3") != null) {
                        microVersion = resultSet.getInt("APPL_VER3");
                    } else if (this.attemptColumnFetch(resultSet, "APP_VER3") != null) {
                        microVersion = resultSet.getInt("APP_VER3");
                    }
                    if (Version.getInstance().getDBVersion() >= 5200 && platformName != null || Version.getInstance().getDBVersion() >= 5100) {
                        if (majorVersion != null && minorVersion != null && microVersion != null) {
                            Platform platform = platformName != null ? ResourceFactory.getSingleton().getPlatform(platformName) : null;
                            TSApplication tsApplication = ResourceFactory.getSingleton().getTSApplication(platform, applName, majorVersion, minorVersion, microVersion);
                            rowData[j++] = tsApplication;
                        } else {
                            rowData[j++] = applName;
                        }
                    }
                }
            } else if (columnName.equals("OBJECT")) {
                objectName = resultSet.getString("OBJECT");
                typeName = resultSet.getString("TYPE");
                resource = ResourceFactory.getSingleton().getResource(typeName, objectName);
                rowData[j++] = resource;
            } else if (columnName.equals("RESNAME")) {
                objectName = resultSet.getString("RESNAME");
                typeName = resultSet.getString("RESTYPE");
                resource = ResourceFactory.getSingleton().getResource(typeName, objectName);
                rowData[j++] = resource;
            } else if (columnName.equals("PROGRAM")) {
                String programName = resultSet.getString("PROGRAM");
                Program program = ResourceFactory.getSingleton().getProgram(programName);
                rowData[j++] = program;
            } else if (columnName.equals("TRANSID")) {
                String transactionName = resultSet.getString("TRANSID");
                Transaction transaction = ResourceFactory.getSingleton().getTransaction(transactionName);
                rowData[j++] = transaction;
            } else if (columnName.equals("TASKID")) {
                String taskName = resultSet.getString("TASKID");
                String transactionName = resultSet.getString("TRANSID");
                String applId = null;
                if (this.attemptColumnFetch(resultSet, "APPLID") != null) {
                    applId = resultSet.getString("APPLID");
                }
                Transaction transaction = ResourceFactory.getSingleton().getTransaction(transactionName);
                Task task = ResourceFactory.getSingleton().getTask(transaction, taskName, applId);
                rowData[j++] = task;
            } else if (columnName.equals("RESOURCE")) {
                String resourceName = resultSet.getString("RESOURCE");
                String resType = null;
                resType = this.attemptColumnFetch(resultSet, "TYPE");
                if (!IAUtilities.hasContent(resType)) {
                    resType = this.attemptColumnFetch(resultSet, "RESTYPE");
                }
                if (resType != null && IAUtilities.hasContent(resType) && IAUtilities.hasContent(resourceName)) {
                    resource = ResourceFactory.getSingleton().getResource(resType, resourceName);
                    rowData[j++] = resource;
                } else {
                    this.defaultProcessMethod(resultSet, rowData, j++, columnName, columnsToInclude);
                }
            } else if (columnName.equals("APPLID")) {
                name = resultSet.getString("APPLID");
                Region region = ResourceFactory.getSingleton().getRegion(name);
                rowData[j++] = region;
            } else if (columnName.equals("CMD_TCB_CPUTIME_BEFORE") || columnName.equals("CMD_TCB_CPUTIME_AFTER")) {
                String todValue = resultSet.getString(columnName).trim();
                rowData[j++] = IAUtilities.getUserFriendlyTodMilliseconds(todValue);
            } else if (columnName.equals("PLATFORM")) {
                name = resultSet.getString("PLATFORM");
                Platform platform = ResourceFactory.getSingleton().getPlatform(name);
                rowData[j++] = platform;
            } else {
                this.defaultProcessMethod(resultSet, rowData, j++, columnName, columnsToInclude);
            }
            ++i;
        }
        row.setData(rowData);
        Debug.exit((Logger)logger, (String)QueryCommand.class.getName(), (String)"processRow", (Object)("return: " + row));
        return row;
    }

    private void defaultProcessMethod(ResultSet resultSet, Object[] rowData, int rowDataIndex, String columnName, List columnsToInclude) throws SQLException {
        Debug.enter((Logger)logger, (String)QueryCommand.class.getName(), (String)"defaultProcessMethod", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "row Data length: " + (rowData == null ? rowData : Integer.valueOf(rowData.length)), "columnName: " + columnName, "columnsToInclude size: " + (columnsToInclude == null ? columnsToInclude : Integer.valueOf(columnsToInclude.size())), "rowDataInfex: " + rowDataIndex});
        if (columnsToInclude == null) {
            columnsToInclude = new ArrayList<String>(this.presentationObject.getSelection().getSelect().getColumns().size());
            int k = 0;
            while (k < this.presentationObject.getSelection().getSelect().getColumns().size()) {
                columnsToInclude.add(((ColumnReference)this.presentationObject.getSelection().getSelect().getColumns().get(k)).getColumnName());
                ++k;
            }
        }
        if (columnsToInclude.contains(columnName)) {
            rowData[rowDataIndex] = resultSet.getString(columnName).trim();
        }
        Debug.exit((Logger)logger, (String)QueryCommand.class.getName(), (String)"defaultProcessMethod");
    }

    @Override
    public String[] getColumns() {
        Debug.enter((Logger)logger, (String)QueryCommand.class.getName(), (String)"getColumns", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Iterator<ColumnReference> iter = this.orderByColumns.iterator();
        String[] result = new String[this.orderByColumns.size()];
        int i = 0;
        while (iter.hasNext()) {
            ColumnReference column = iter.next();
            result[i] = column.getColumnName();
            ++i;
        }
        Debug.exit((Logger)logger, (String)QueryCommand.class.getName(), (String)"getColumns", (Object)("result length: " + result.length));
        return result;
    }

    public List<String> getTablesAffectedByCollectionID() {
        Debug.enter((Logger)logger, (String)QueryCommand.class.getName(), (String)"getTablesAffectedByCollectionID", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ArrayList<String> result = new ArrayList<String>();
        if (IAUtilities.hasContent(collectionId)) {
            this.collectionIdAtRuntime = collectionId;
            Collection tables = this.presentationObject.getSelection().getTargetTables();
            List<String> affectedTables = IAUtilities.getTablesWithCollectionId();
            for (String table : tables) {
                if (!affectedTables.contains(table)) continue;
                result.add(table);
            }
        }
        Debug.exit((Logger)logger, (String)QueryCommand.class.getName(), (String)"getTablesAffectedByCollectionID", (Object)("result size: " + result.size()));
        return result;
    }

    public Selection getSelectionObject() {
        Debug.enter((Logger)logger, (String)QueryCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        List<String> tables = this.getTablesAffectedByCollectionID();
        Iterator<String> iter = tables.iterator();
        Selection sourceSelection = this.presentationObject.getSelection();
        Collection sourceTables = sourceSelection.getTargetTables();
        String[] sourceTablesArray = tables.toArray(new String[0]);
        Selection selection = PresentationFactory.getInstance().createSelectForTable(sourceTablesArray, new String[0]);
        selection.setSelect(sourceSelection.getSelect());
        ConstraintElement condition = sourceSelection.getCondition();
        if (condition != null) {
            selection.appendCondition(condition, QueryElement.Predicate.AND);
        }
        selection.setOrderBy(sourceSelection.getOrderBy());
        while (iter.hasNext()) {
            String table = iter.next();
            selection.appendCondition("COLLECTION_ID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        Debug.exit((Logger)logger, (String)QueryCommand.class.getName(), (String)"getSelectionObject", (Object)("selection: " + selection));
        return selection;
    }

    private String attemptColumnFetch(ResultSet rs, String columnName) throws SQLException {
        Debug.enter((Logger)logger, (String)QueryCommand.class.getName(), (String)"attemptColumnFetch", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "columnName: " + columnName});
        String result = null;
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int columnCount = rsMetaData.getColumnCount();
        int i = 1;
        while (i <= columnCount) {
            if (rsMetaData.getColumnName(i).equals(columnName)) {
                result = rs.getString(i);
                break;
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)QueryCommand.class.getName(), (String)"attemptColumnFetch", (Object)("result: " + result));
        return result;
    }
}

