/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.ExitPropertySource;
import com.ibm.cics.ia.model.FilePropertySource;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.RegionPropertySource;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.TDQueuePropertySource;
import com.ibm.cics.ia.model.TSQueuePropertySource;
import com.ibm.cics.ia.model.TransactionPropertySource;
import com.ibm.cics.ia.model.WebservicePropertySource;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Logger;

public class PropertiesCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(PropertiesCommand.class.getPackage().getName());
    private Resource resource;
    private String[] columns;

    public PropertiesCommand(Resource Resource2) {
        this.resource = Resource2;
        this.setAsync(false);
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)PropertiesCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap<String, String> properties = new HashMap<String, String>();
        int i = 1;
        while (i <= this.columns.length) {
            String value = resultSet.getString(i);
            value = value != null ? value.trim() : "";
            properties.put(resultSet.getMetaData().getColumnName(i), value);
            ++i;
        }
        Debug.exit((Logger)logger, (String)PropertiesCommand.class.getName(), (String)"processRow", (Object)("result size: " + properties.size()));
        return properties;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)PropertiesCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String tableName = null;
        String fieldName = null;
        if (this.resource.getTypeName().equals("PROGRAM")) {
            tableName = IAUtilities.getProgramPropertyTableName();
            this.columns = Program.getPropertyIDs();
            fieldName = "PROGRAM_NAME";
        } else if (this.resource.getTypeName().equals("TRANSID")) {
            tableName = IAUtilities.getTransactionPropertyTableName();
            this.columns = TransactionPropertySource.getPropertyIDs();
            fieldName = "TRANSID";
        } else if (this.resource.getTypeName().equals("WEBSERVICE")) {
            tableName = IAUtilities.getWebservicePropertyTableName();
            this.columns = WebservicePropertySource.getPropertyIDs();
            fieldName = "NAME";
        } else if (this.resource.getTypeName().equals("SERVICE")) {
            tableName = IAUtilities.getWebservicePropertyTableName();
            this.columns = WebservicePropertySource.getPropertyIDs();
            fieldName = "NAME";
        } else if (this.resource.getTypeName().equals("FILE")) {
            tableName = IAUtilities.getFilePropertyTableName();
            this.columns = FilePropertySource.getPropertyIDs();
            fieldName = "FILE_NAME";
        } else if (this.resource.getTypeName().equals("TDQUEUE")) {
            tableName = IAUtilities.getTDQueuePropertyTableName();
            fieldName = "TDQUEUE_NAME";
            this.columns = TDQueuePropertySource.getPropertyIDs();
        } else if (this.resource.getTypeName().equals("TSQUEUE")) {
            tableName = IAUtilities.getTSQueuePropertyTableName();
            fieldName = "TSQUEUE_NAME";
            this.columns = TSQueuePropertySource.getPropertyIDs();
        } else if (this.resource.getTypeName().equals("TSQUEUE SHARED")) {
            tableName = IAUtilities.getTSQueuePropertyTableName();
            fieldName = "TSQUEUE_NAME";
        } else if (this.resource.getTypeName().equals("TSQUEUE AUX")) {
            tableName = IAUtilities.getTSQueuePropertyTableName();
            fieldName = "TSQUEUE_NAME";
            this.columns = TSQueuePropertySource.getPropertyIDs();
        } else if (this.resource.getTypeName().equals("EXIT")) {
            tableName = IAUtilities.getExitPropertyTableName();
            fieldName = "EXIT_PROGRAM";
            this.columns = ExitPropertySource.getPropertyIDs();
        } else if (this.resource.getTypeName().equals("APPLID")) {
            tableName = IAUtilities.getRegionInfoName();
            fieldName = "APPLID";
            this.columns = RegionPropertySource.getPropertyIDs();
        }
        Selection result = PresentationFactory.getInstance().createSelectForTable(tableName, null);
        result.appendCondition(fieldName, tableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getName()}, QueryElement.Predicate.AND, false);
        if (IAUtilities.hasContent(collectionId)) {
            result.appendCondition("COLLECTION_ID", tableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        if (this.resource.getTypeName().equals("PROGRAM")) {
            String[] stringArray = this.columns;
            int n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                String column = stringArray[n2];
                result.getSelect().addSelectionColumn(column, tableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
                ++n2;
            }
        }
        Debug.exit((Logger)logger, (String)PropertiesCommand.class.getName(), (String)"getSelectionObject", (Object)("result: " + result));
        return result;
    }
}

