/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Webservice;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class ProgramsForWebserviceCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ProgramsForWebserviceCommand.class.getPackage().getName());
    private Webservice webservice;
    private Region region;

    public ProgramsForWebserviceCommand(Webservice webservice, Region region) {
        this.webservice = webservice;
        this.region = region;
        this.setAsync(false);
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        String programID = resultSet.getString(1);
        Program program = ResourceFactory.getSingleton().getProgram(programID.trim());
        return program;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)ProgramsForWebserviceCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getWebservicePropertyTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("PROGRAM", table, ColumnReference.DataType.String, null);
        result.appendCondition("NAME", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.webservice.getName()}, QueryElement.Predicate.AND, false);
        if (this.region != null) {
            result.appendCondition("APPLID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.region.getName()}, QueryElement.Predicate.AND, false);
        }
        Debug.exit((Logger)logger, (String)ProgramsForWebserviceCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

