/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.ProgramResourceConnectionsCommand;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ProgramResourceDB2ConnectionsCommand
extends ProgramResourceConnectionsCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ProgramResourceDB2ConnectionsCommand.class.getPackage().getName());

    public ProgramResourceDB2ConnectionsCommand(Region region, Platform platform, TSApplication tsApplication, List<Program> programs, List<String> resources) {
        super(region, platform, tsApplication, programs, resources);
    }

    @Override
    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = this.getTableName();
        Selection selection = PresentationFactory.getInstance().createSelectForTable(table, null);
        selection.getSelect().setDistinct(true);
        selection.getSelect().addSelectionColumn("PROGRAM", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("RESTYPE", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("RESNAME", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("FUNCTION", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        if (this.region != null) {
            selection.appendCondition("APPLID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.region.getName()}, QueryElement.Predicate.AND, false);
        }
        if (this.platform != null) {
            selection.appendCondition("PLATFORM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.platform.getName()}, QueryElement.Predicate.AND, false);
        }
        if (this.tsApplication != null) {
            selection.appendCondition("APPL_NAME", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.tsApplication.getName()}, QueryElement.Predicate.AND, false);
            selection.appendCondition("APPL_VER1", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{this.tsApplication.getMajorVersion()}, QueryElement.Predicate.AND, false);
            selection.appendCondition("APPL_VER2", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{this.tsApplication.getMinorVersion()}, QueryElement.Predicate.AND, false);
            selection.appendCondition("APPL_VER3", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{this.tsApplication.getMicroVersion()}, QueryElement.Predicate.AND, false);
        }
        ArrayList<String> programNames = new ArrayList<String>();
        for (Program program : this.programs) {
            programNames.add(program.getName());
        }
        selection.appendCondition("PROGRAM", table, ColumnReference.DataType.String, Comparator.IN, programNames.toArray(), QueryElement.Predicate.AND, false);
        selection.appendCondition("RESTYPE", table, ColumnReference.DataType.String, Comparator.IN, this.resources.toArray(), QueryElement.Predicate.AND, false);
        if (IAUtilities.hasContent(collectionId)) {
            selection.appendCondition("COLLECTION_ID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSelectionObject");
        return selection;
    }

    @Override
    public String getTableName() {
        return IAUtilities.getDB2DataTableName();
    }
}

