/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class PlatformsForResourceCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(PlatformsForResourceCommand.class.getPackage().getName());
    private Resource resource;

    public PlatformsForResourceCommand(Resource aResource) {
        this.resource = aResource;
        this.setAsync(false);
        this.setDescription("Regions for " + aResource.toString());
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        String platformName = resultSet.getString(1).trim();
        Platform platform = ResourceFactory.getSingleton().getPlatform(platformName);
        return platform;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)PlatformsForResourceCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getResourcesTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().addSelectionColumn("PLATFORM", table, ColumnReference.DataType.String, null);
        result.getSelect().setDistinct(true);
        if (IAUtilities.hasContent(collectionId)) {
            result.appendCondition("COLLECTION_ID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        result.appendCondition("OBJECT", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getName()}, QueryElement.Predicate.AND, false);
        result.appendCondition("TYPE", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getTypeName()}, QueryElement.Predicate.AND, false);
        Debug.exit((Logger)logger, (String)PlatformsForResourceCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

