/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Engine;
import com.ibm.cics.dbfunc.command.RowProcessor;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.Version;
import com.ibm.cics.ia.runtime.VersionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class IASQLCommand
extends SQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(IASQLCommand.class.getPackage().getName());
    protected static String collectionId = "";
    protected static final String nullValue = ":NULL";
    protected static String region = "";
    protected static String collectionIdByResource = "";

    public IASQLCommand() {
        this.connectionCategory = "com.ibm.cics.ia.connection.db2";
    }

    public Map<String, Object> getParameterMap() {
        Debug.event((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getParameterMap");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(nullValue, null);
        return map;
    }

    protected Engine getEngine() {
        return new Engine("com.ibm.cics.ia.connection.db2", (RowProcessor)this);
    }

    public void start() {
        boolean dbValid;
        try {
            dbValid = Version.getInstance().isDBValid();
        }
        catch (VersionException e) {
            dbValid = false;
        }
        if (dbValid) {
            super.start();
        }
    }

    public static void setCollectionId(String aCollectionId) {
        Debug.enter((Logger)logger, (String)IASQLCommand.class.getName(), (String)"setCollectionId", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "aColectionId: " + aCollectionId});
        collectionId = aCollectionId;
        IAPlugin.getDefault().fireCollectionIdChanged(aCollectionId);
        Debug.exit((Logger)logger, (String)IASQLCommand.class.getName(), (String)"setCollectionId");
    }

    public static String getCollectionId() {
        return collectionId;
    }

    public static void setRegion(String regionName) {
        Debug.enter((Logger)logger, (String)IASQLCommand.class.getName(), (String)"regionName", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "regionName: " + regionName});
        region = regionName;
        Debug.exit((Logger)logger, (String)IASQLCommand.class.getName(), (String)"regionName");
    }

    public static String getRegion() {
        return region;
    }

    public static void setCollectionIdByResource(String collectionIdName) {
        Debug.enter((Logger)logger, (String)IASQLCommand.class.getName(), (String)"collectionIdName", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "collectionIdName: " + collectionIdName});
        collectionIdByResource = collectionIdName;
        Debug.exit((Logger)logger, (String)IASQLCommand.class.getName(), (String)"collectionIdName");
    }

    public static String getCollectionIdByResource() {
        return collectionIdByResource;
    }

    public static List runCommandSynch(SQLCommand command) {
        Debug.enter((Logger)logger, (String)IASQLCommand.class.getName(), (String)"runCommandSynch", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "command: " + command.getSQLString()});
        command.setAsync(false);
        command.start();
        List results = command.getResults();
        Debug.exit((Logger)logger, (String)IASQLCommand.class.getName(), (String)"runCommandSynch", (Object)("result size: " + (results == null ? results : Integer.valueOf(results.size()))));
        return results == null ? new ArrayList() : results;
    }
}

