/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class GetIdenticalProgramFlowsCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(GetIdenticalProgramFlowsCommand.class.getPackage().getName());

    public Object processRow(ResultSet resultSet) throws SQLException {
        Integer treeGroupId = (Integer)resultSet.getObject(1);
        Integer count = (Integer)resultSet.getObject(2);
        Integer rootTaskId = (Integer)resultSet.getObject(3);
        return new Integer[]{treeGroupId, count, rootTaskId};
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getTaskFlowIndexTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().addSelectionColumn("ID_TREE_GROUP", table, ColumnReference.DataType.Integer, null);
        result.getSelect().addSelectionColumn("*", table, ColumnReference.DataType.String, ColumnReference.Function.COUNT);
        result.getSelect().addSelectionColumn("ID_TASK_ROOT", table, ColumnReference.DataType.Integer, ColumnReference.Function.MIN);
        result.appendCondition("ID_TASK_PARENT", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[1], QueryElement.Predicate.AND, false);
        result.appendCondition("ID_TREE_GROUP", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[1], QueryElement.Predicate.AND, true);
        result.addGroupByCondition("ID_TREE_GROUP", table);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSelectionObject");
        return result;
    }
}

