/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class GetApplicationInfoCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(GetApplicationInfoCommand.class.getPackage().getName());
    private final String[] regions;
    private final List<ApplicationInfo> infos = new ArrayList<ApplicationInfo>();
    private ApplicationInfo currentInfo;

    public GetApplicationInfoCommand(String ... regions) {
        this.regions = regions;
    }

    public Object processRow(ResultSet rs) throws SQLException {
        Debug.enter((Logger)logger, (String)GetApplicationInfoCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String name = rs.getString(1).trim();
        ApplicationInfo.Version version = new ApplicationInfo.Version(rs.getInt(2), rs.getInt(3), rs.getInt(4));
        if (this.currentInfo == null || !this.currentInfo.name.equals(name)) {
            this.currentInfo = new ApplicationInfo(name);
            this.infos.add(this.currentInfo);
        }
        this.currentInfo.versions.add(version);
        Debug.exit((Logger)logger, (String)GetApplicationInfoCommand.class.getName(), (String)"processRow");
        return null;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)GetApplicationInfoCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getResourcesTableName();
        Selection selection = PresentationFactory.getInstance().createSelectForTable(table, null);
        selection.getSelect().setDistinct(true);
        selection.getSelect().addSelectionColumn("APPL_NAME", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("APPL_VER1", table, ColumnReference.DataType.Integer, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("APPL_VER2", table, ColumnReference.DataType.Integer, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("APPL_VER3", table, ColumnReference.DataType.Integer, ColumnReference.Function.NONE);
        selection.appendCondition("APPLID", table, ColumnReference.DataType.String, Comparator.IN, (Object[])this.regions, QueryElement.Predicate.AND, false);
        selection.appendCondition("APPL_NAME", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{""}, QueryElement.Predicate.AND, true);
        selection.addOrderByCondition("APPL_NAME", table, Direction.ASC);
        selection.addOrderByCondition("APPL_VER1", table, Direction.ASC);
        selection.addOrderByCondition("APPL_VER2", table, Direction.ASC);
        selection.addOrderByCondition("APPL_VER3", table, Direction.ASC);
        Debug.exit((Logger)logger, (String)GetApplicationInfoCommand.class.getName(), (String)"getSelectionObject");
        return selection;
    }

    public List<ApplicationInfo> getApplicationInfos() {
        return this.infos;
    }

    public static class ApplicationInfo {
        private String name;
        private final List<Version> versions;
        private List<ApplicationInfo> children;

        public ApplicationInfo(String name) {
            this.name = name;
            if (this.name != null) {
                this.name = name.trim();
            }
            this.versions = new ArrayList<Version>();
        }

        public ApplicationInfo() {
            this.versions = new ArrayList<Version>();
        }

        public ApplicationInfo(ApplicationInfo otherInfo) {
            this.name = otherInfo.name;
            if (this.name != null) {
                this.name = this.name.trim();
            }
            this.versions = otherInfo.versions;
            this.children = otherInfo.children;
        }

        public String toString() {
            return String.valueOf(this.name) + (this.versions.size() == 1 ? " " + this.versions.get(0) : "");
        }

        public List<ApplicationInfo> getChildren() {
            if (this.children == null) {
                this.children = new ArrayList<ApplicationInfo>();
                if (this.versions.size() > 1) {
                    int i = 0;
                    while (i < this.versions.size()) {
                        ApplicationInfo app = new ApplicationInfo(this.name);
                        app.versions.add(this.versions.get(i));
                        this.children.add(app);
                        ++i;
                    }
                }
            }
            return this.children;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setMajorVersion(int value) {
            if (this.versions.isEmpty()) {
                this.versions.add(new Version());
            }
            this.versions.get(0).setMajor(value);
        }

        public void setMinorVersion(int value) {
            if (this.versions.isEmpty()) {
                this.versions.add(new Version());
            }
            this.versions.get(0).setMinor(value);
        }

        public void setMicroVersion(int value) {
            if (this.versions.isEmpty()) {
                this.versions.add(new Version());
            }
            this.versions.get(0).setMicro(value);
        }

        public String getName() {
            return this.name;
        }

        public Integer getMajorVersion() {
            return !this.versions.isEmpty() ? Integer.valueOf(this.versions.get(0).major) : null;
        }

        public Integer getMinorVersion() {
            return !this.versions.isEmpty() ? Integer.valueOf(this.versions.get(0).minor) : null;
        }

        public Integer getMicroVersion() {
            return !this.versions.isEmpty() ? Integer.valueOf(this.versions.get(0).micro) : null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ApplicationInfo other = (ApplicationInfo)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.versions == null ? other.versions != null : !this.versions.equals(other.versions));
        }

        static class Version {
            private int major;
            private int minor;
            private int micro;

            public Version() {
            }

            public Version(int major, int minor, int micro) {
                this.major = major;
                this.minor = minor;
                this.micro = micro;
            }

            public String toString() {
                return "(" + this.major + "." + this.minor + "." + this.micro + ")";
            }

            public void setMajor(int major) {
                this.major = major;
            }

            public void setMinor(int minor) {
                this.minor = minor;
            }

            public void setMicro(int micro) {
                this.micro = micro;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Version other = (Version)obj;
                if (this.major != other.major) {
                    return false;
                }
                if (this.micro != other.micro) {
                    return false;
                }
                return this.minor == other.minor;
            }
        }
    }
}

