/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.AbstractFindCICSObjectsForApplication;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Service;
import com.ibm.cics.ia.model.Webservice;
import com.ibm.cics.ia.query.ApplicationSubQuery;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class FindWebservicesForApplicationCommand
extends AbstractFindCICSObjectsForApplication {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindWebservicesForApplicationCommand.class.getPackage().getName());

    @Override
    protected String getResourceType() {
        return "WEBSERVICE";
    }

    @Override
    protected int getResourceNameSize() {
        return 32;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)FindWebservicesForApplicationCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String webservID = resultSet.getString(1).trim();
        String resourceType = resultSet.getString(2).trim();
        if (resourceType.equals("WEBSERVICE")) {
            Webservice webservice = ResourceFactory.getSingleton().getWebservice(webservID);
            Debug.exit((Logger)logger, (String)FindWebservicesForApplicationCommand.class.getName(), (String)"processRow");
            return webservice;
        }
        Service service = ResourceFactory.getSingleton().getService(webservID);
        Debug.exit((Logger)logger, (String)FindWebservicesForApplicationCommand.class.getName(), (String)"processRow");
        return service;
    }

    @Override
    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindWebservicesForApplicationCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String tableName = IAUtilities.getResourcesTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(tableName, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("OBJECT", tableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("TYPE", tableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        if (IAUtilities.hasContent(collectionId)) {
            result.appendCondition("COLLECTION_ID", tableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        result.appendCondition("TYPE", tableName, ColumnReference.DataType.String, Comparator.IN, new Object[]{"WEBSERVICE", "SERVICE"}, QueryElement.Predicate.AND, false);
        result.appendCondition("OBJECT", tableName, ColumnReference.DataType.String, Comparator.IN, new Object[]{new ApplicationSubQuery(this.getResourceType(), this.criteria).getPresentation().getSelection()}, QueryElement.Predicate.AND, false);
        if (IAUtilities.hasContent(this.resourceName) && this.resourceName.length() > 0) {
            if (IAUtilities.isExactName(this.resourceName)) {
                result.appendCondition("OBJECT", tableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resourceName}, QueryElement.Predicate.AND, false);
            } else {
                result.appendCondition("OBJECT", tableName, ColumnReference.DataType.String, Comparator.LI, new Object[]{this.resourceName}, QueryElement.Predicate.AND, false);
            }
        }
        Debug.exit((Logger)logger, (String)FindWebservicesForApplicationCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

