/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Task;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.logging.Logger;

public class FindUserCommandFlowRunsCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindUserCommandFlowRunsCommand.class.getPackage().getName());

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)FindUserCommandFlowRunsCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap<String, Object> values = new HashMap<String, Object>();
        int i = 0;
        String ownerUserId = resultSet.getString(++i).trim();
        String traceId = resultSet.getString(++i).trim();
        String cmdFlowId = resultSet.getString(++i).trim();
        String userid = resultSet.getString(++i).trim();
        Timestamp cmdTimeLocal = resultSet.getTimestamp(++i);
        String taskId = resultSet.getString(++i).trim();
        String transId = resultSet.getString(++i).trim();
        Transaction transaction = ResourceFactory.getSingleton().getTransaction(transId);
        String applId = resultSet.getString(++i).trim();
        Task task = new Task(transaction, taskId, null, cmdTimeLocal, traceId, applId);
        values.put("OWNER_USERID", ownerUserId);
        values.put("CMD_TIME_LOCAL", cmdTimeLocal.toString());
        values.put("CMDFLOW_ID", cmdFlowId);
        values.put("TASKID", task);
        values.put("USERID", userid);
        values.put("TRANSID", transId);
        Debug.exit((Logger)logger, (String)FindUserCommandFlowRunsCommand.class.getName(), (String)"processRow");
        return values;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindUserCommandFlowRunsCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String commandFlowIndexTableName = IAUtilities.getCommandFlowIndexTableName();
        String commandFlowTableName = IAUtilities.getCommandFlowTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(new String[]{commandFlowIndexTableName, commandFlowTableName}, new String[2]);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("OWNER_USERID", commandFlowIndexTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("TRACE_ID", commandFlowIndexTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("CMDFLOW_ID", commandFlowIndexTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("USERID", commandFlowTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("CMD_TIME_LOCAL", commandFlowTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("TASKID", commandFlowTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("TRANSID", commandFlowTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("APPLID", commandFlowTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.addOrderByCondition("OWNER_USERID", commandFlowIndexTableName, Direction.ASC);
        result.addOrderByCondition("CMD_TIME_LOCAL", commandFlowTableName, Direction.ASC);
        result.addOrderByCondition("CMDFLOW_ID", commandFlowIndexTableName, Direction.ASC);
        FindUserCommandFlowRunsCommand.joinCmdFlowAndCmdFlowIndex(result);
        Debug.exit((Logger)logger, (String)FindUserCommandFlowRunsCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }

    public static void joinCmdFlowAndCmdFlowIndex(Selection selection) {
        ColumnReference traceIdRef = PresentationFactory.getInstance().createBasicColumn("TRACE_ID", IAUtilities.getCommandFlowTableName(), ColumnReference.DataType.String);
        selection.appendCondition("TRACE_ID", IAUtilities.getCommandFlowIndexTableName(), ColumnReference.DataType.String, Comparator.EQ, new Object[]{traceIdRef}, QueryElement.Predicate.AND, false);
        selection.appendCondition("FUNCTION", IAUtilities.getCommandFlowTableName(), ColumnReference.DataType.String, Comparator.EQ, new Object[]{"START OF TRANSACTION"}, QueryElement.Predicate.AND, false);
    }
}

