/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.dbfunc.DBUtilities;
import com.ibm.cics.dbfunc.command.StoredProcedureCommand;
import com.ibm.cics.dbfunc.command.StoredProcedureDefinition;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.model.Operation;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPAP1;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class FindTSApplicationsCommand
extends StoredProcedureCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindTSApplicationsCommand.class.getPackage().getName());
    private String searchMask = null;
    private String platformMask = null;

    public FindTSApplicationsCommand() {
        this.setCategory("com.ibm.cics.ia.connection.db2");
    }

    public void setApplicationName(String searchMask) {
        this.searchMask = searchMask;
    }

    public void setPlatformName(String platformMask) {
        this.platformMask = platformMask;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)FindTSApplicationsCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Map columns = null;
        try {
            columns = DBUtilities.getColumnsFromResultSet((ResultSet)resultSet);
        }
        catch (SQLException e) {
            Debug.warning((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"processRow", (Throwable)e, new HashMap());
        }
        TSApplication application = null;
        if (columns != null) {
            int columnRef;
            String applName = "";
            int applVer1 = 0;
            int applVer2 = 0;
            int applVer3 = 0;
            String applOper = "";
            String platformName = "";
            if (columns.containsKey("PLATFORM")) {
                columnRef = (Integer)columns.get("PLATFORM");
                platformName = resultSet.getString(columnRef).trim();
            }
            if (columns.containsKey("APPL_NAME")) {
                columnRef = (Integer)columns.get("APPL_NAME");
                applName = resultSet.getString(columnRef).trim();
            }
            if (columns.containsKey("APPL_VER1")) {
                columnRef = (Integer)columns.get("APPL_VER1");
                applVer1 = resultSet.getInt(columnRef);
            }
            if (columns.containsKey("APPL_VER2")) {
                columnRef = (Integer)columns.get("APPL_VER2");
                applVer2 = resultSet.getInt(columnRef);
            }
            if (columns.containsKey("APPL_VER3")) {
                columnRef = (Integer)columns.get("APPL_VER3");
                applVer3 = resultSet.getInt(columnRef);
            }
            if (columns.containsKey("APPL_OPER")) {
                columnRef = (Integer)columns.get("APPL_OPER");
                applOper = resultSet.getString(columnRef).trim();
            }
            if (IAUtilities.hasContent(platformName)) {
                Platform platform = ResourceFactory.getSingleton().getPlatform(platformName);
                application = ResourceFactory.getSingleton().getTSApplication(platform, applName, applVer1, applVer2, applVer3);
                platform.getTsApplications().add(application);
                application.setPlatform(platform);
            } else {
                application = ResourceFactory.getSingleton().getTSApplication(null, applName, applVer1, applVer2, applVer3);
            }
            if (IAUtilities.hasContent(applOper)) {
                Operation operation = new Operation(application, applOper);
                application.addOperation(operation);
            }
        }
        Debug.exit((Logger)logger, (String)FindTSApplicationsCommand.class.getName(), (String)"processRow");
        return application;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindTSApplicationsCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Selection result = null;
        if (DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2").isProcedureAvailable((StoredProcedureDefinition)new ProcedureCIUSPAP1())) {
            ProcedureCIUSPAP1 sp = new ProcedureCIUSPAP1();
            String applicationName = this.searchMask;
            if (IAUtilities.hasContent(this.searchMask) && !IAUtilities.isExactName(this.searchMask)) {
                applicationName = IAUtilities.toLikeString(this.searchMask);
            }
            String platformName = this.platformMask;
            if (IAUtilities.hasContent(this.platformMask) && !IAUtilities.isExactName(this.platformMask)) {
                platformName = IAUtilities.toLikeString(this.platformMask);
            }
            result = (Selection)sp.getSelectionObject("LIST", platformName, applicationName, 0, 0, 0, null);
        }
        Debug.exit((Logger)logger, (String)FindTSApplicationsCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

