/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Logger;

public class FindScanSummaryCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindScanSummaryCommand.class.getPackage().getName());
    private String programName = "";

    public void setProgramName(String aProgramName) {
        this.programName = aProgramName;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)FindScanSummaryCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap<String, String> properties = new HashMap<String, String>();
        int i = 1;
        while (i <= SQLDefinitions.SCANNER_DETAILS_ATTRIBUTES.getAdjustedAttributes().length) {
            String value = resultSet.getString(i);
            value = value != null ? value.trim() : "";
            properties.put(resultSet.getMetaData().getColumnName(i), value);
            ++i;
        }
        Debug.exit((Logger)logger, (String)FindScanSummaryCommand.class.getName(), (String)"processRow");
        return properties;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindScanSummaryCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getScanSummaryTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().setDistinct(true);
        String[] stringArray = SQLDefinitions.SCANNER_DETAILS_ATTRIBUTES.getAdjustedAttributes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            result.getSelect().addSelectionColumn(column, table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
            ++n2;
        }
        if (IAUtilities.hasContent(this.programName)) {
            result.appendCondition("PROGRAM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.programName}, QueryElement.Predicate.AND, false);
        }
        Debug.exit((Logger)logger, (String)FindScanSummaryCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

