/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class FindPlatformsAndApplicationsUsingResourceCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindPlatformsAndApplicationsUsingResourceCommand.class.getPackage().getName());
    private Region region;
    private Platform platform;
    private Resource resource;
    private boolean platformSupported = false;

    public boolean isPlatformSupported() {
        return this.platformSupported;
    }

    public FindPlatformsAndApplicationsUsingResourceCommand(Region aRegion, Platform aPlatform, Resource aResource) {
        this.region = aRegion;
        this.resource = aResource;
        this.platform = aPlatform;
        if (Version.getInstance().getDBVersion() >= 5200) {
            this.platformSupported = true;
        }
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)FindPlatformsAndApplicationsUsingResourceCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Object[] result = new Object[2];
        int pos = 0;
        result[0] = this.region == null ? ResourceFactory.getSingleton().getRegion(resultSet.getString(++pos)) : this.region;
        TSApplication application = null;
        String applName = resultSet.getString(++pos).trim();
        int applVer1 = resultSet.getInt(++pos);
        int applVer2 = resultSet.getInt(++pos);
        int applVer3 = resultSet.getInt(++pos);
        application = ResourceFactory.getSingleton().getTSApplication(null, applName, applVer1, applVer2, applVer3);
        result[1] = application;
        Debug.exit((Logger)logger, (String)FindPlatformsAndApplicationsUsingResourceCommand.class.getName(), (String)"processRow");
        return result;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindPlatformsAndApplicationsUsingResourceCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getResourcesTableName();
        Selection selection = PresentationFactory.getInstance().createSelectForTable(table, null);
        selection.getSelect().setDistinct(true);
        if (!this.platformSupported && this.region == null) {
            selection.getSelect().addSelectionColumn("APPLID", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
            selection.addOrderByCondition("APPLID", table, Direction.ASC);
        }
        if (this.platformSupported && this.platform == null) {
            selection.getSelect().addSelectionColumn("PLATFORM", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
            selection.addOrderByCondition("PLATFORM", table, Direction.ASC);
        }
        selection.getSelect().addSelectionColumn("APPL_NAME", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("APPL_VER1", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("APPL_VER2", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("APPL_VER3", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("APPL_OPER", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        if (!this.platformSupported && this.region != null && IAUtilities.hasContent(this.region.getName())) {
            selection.appendCondition("APPLID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.region.getName()}, QueryElement.Predicate.AND, false);
        }
        if (this.platformSupported && this.platform != null && IAUtilities.hasContent(this.platform.getName())) {
            selection.appendCondition("PLATFORM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.platform.getName()}, QueryElement.Predicate.AND, false);
        }
        if (this.resource != null && IAUtilities.hasContent(this.resource.getTypeName())) {
            selection.appendCondition("TYPE", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getTypeName()}, QueryElement.Predicate.AND, false);
        }
        if (this.resource != null && IAUtilities.hasContent(this.resource.getName())) {
            selection.appendCondition("OBJECT", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getName()}, QueryElement.Predicate.AND, false);
        }
        selection.addOrderByCondition("APPL_NAME", table, Direction.ASC);
        selection.addOrderByCondition("APPL_OPER", table, Direction.ASC);
        Debug.exit((Logger)logger, (String)FindPlatformsAndApplicationsUsingResourceCommand.class.getName(), (String)"getSelectionObject");
        return selection;
    }
}

