/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Operation;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class FindDeployedOrDeployingRegionsCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindDeployedOrDeployingRegionsCommand.class.getPackage().getName());
    private Object resource;

    public FindDeployedOrDeployingRegionsCommand(Object resource) {
        this.resource = resource;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        return null;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getResourcesTableName();
        Selection selection = PresentationFactory.getInstance().createSelectForTable(table, null);
        selection.getSelect().setDistinct(true);
        selection.getSelect().addSelectionColumn("APPLID", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        if (this.resource instanceof Platform) {
            Platform platform = (Platform)this.resource;
            selection.appendCondition("PLATFORM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{platform.getName()}, QueryElement.Predicate.AND, false);
        } else if (this.resource instanceof TSApplication) {
            TSApplication tsApp = (TSApplication)this.resource;
            FindDeployedOrDeployingRegionsCommand.appendAppRelatedConditions(table, selection, tsApp);
        } else if (this.resource instanceof Operation) {
            Operation operation = (Operation)this.resource;
            TSApplication tsApp = operation.getApplication();
            FindDeployedOrDeployingRegionsCommand.appendAppRelatedConditions(table, selection, tsApp);
            selection.appendCondition("APPL_OPER", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{operation.getName()}, QueryElement.Predicate.AND, false);
        }
        selection.addOrderByCondition("APPLID", table, Direction.ASC);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSelectionObject");
        return selection;
    }

    public static void appendAppRelatedConditions(String table, Selection selection, TSApplication tsApp) {
        Debug.enter((Logger)logger, (String)FindDeployedOrDeployingRegionsCommand.class.getName(), (String)"appendAppRelatedConditions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        selection.appendCondition("APPL_NAME", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{tsApp.getName()}, QueryElement.Predicate.AND, false);
        selection.appendCondition("APPL_VER1", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{tsApp.getMajorVersion()}, QueryElement.Predicate.AND, false);
        selection.appendCondition("APPL_VER2", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{tsApp.getMinorVersion()}, QueryElement.Predicate.AND, false);
        selection.appendCondition("APPL_VER3", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{tsApp.getMicroVersion()}, QueryElement.Predicate.AND, false);
        Debug.exit((Logger)logger, (String)FindDeployedOrDeployingRegionsCommand.class.getName(), (String)"appendAppRelatedConditions");
    }
}

