/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.dbfunc.DBUtilities;
import com.ibm.cics.dbfunc.command.StoredProcedureDefinition;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.commands.IColumnResultsCommand;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.query.QueryResultRow;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPAPP;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class FindDefiningResourcesCommand
extends IASQLCommand
implements IColumnResultsCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindDefiningResourcesCommand.class.getPackage().getName());
    private String application;
    private String resourceType = "";
    private Presentation presentation;
    private String[] columnArray = new String[]{"TYPE", "OBJECT"};
    private static final String DEFN_RESOURCE_TYPE = "APPLIC_TYPE";
    private static final String DEFN_RESOURCE_NAME = "APPLIC_RESNAME";

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindDefiningResourcesCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.presentation != null) {
            Debug.exit((Logger)logger, (String)FindDefiningResourcesCommand.class.getName(), (String)"getSelectionObject");
            return this.presentation;
        }
        if (DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2").isProcedureAvailable((StoredProcedureDefinition)new ProcedureCIUSPAPP())) {
            ProcedureCIUSPAPP sp = new ProcedureCIUSPAPP();
            String appCode = this.application;
            Selection selection = (Selection)sp.getSelectionObject("DEFN", appCode, this.resourceType);
            this.presentation = PresentationFactory.getInstance().createPresentation("All Resources For Application", null, null, selection);
        }
        Debug.exit((Logger)logger, (String)FindDefiningResourcesCommand.class.getName(), (String)"getSelectionObject");
        return this.presentation;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)FindDefiningResourcesCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        QueryResultRow result = new QueryResultRow();
        Object[] rowData = new Object[this.columnArray.length];
        String type = "";
        String object = "";
        Map columns = null;
        try {
            columns = DBUtilities.getColumnsFromResultSet((ResultSet)resultSet);
        }
        catch (SQLException e) {
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"processRow", (Throwable)e, new HashMap());
        }
        if (columns != null) {
            if (columns.containsKey(DEFN_RESOURCE_TYPE)) {
                int columnRef = (Integer)columns.get(DEFN_RESOURCE_TYPE);
                type = resultSet.getString(columnRef);
            }
            if (columns.containsKey(DEFN_RESOURCE_NAME)) {
                int columnRef = (Integer)columns.get(DEFN_RESOURCE_NAME);
                object = resultSet.getString(columnRef);
            }
            Resource resource = ResourceFactory.getSingleton().getResource(type.trim(), object.trim());
            rowData[0] = type;
            rowData[1] = resource;
        }
        result.setData(rowData);
        Debug.exit((Logger)logger, (String)FindDefiningResourcesCommand.class.getName(), (String)"processRow");
        return result;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @Override
    public String[] getColumns() {
        return this.columnArray;
    }
}

