/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class FindCollectionIdsCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindCollectionIdsCommand.class.getPackage().getName());
    private String filterCriteria;

    public Object processRow(ResultSet resultSet) throws SQLException {
        String collectionId = resultSet.getString(1).trim();
        return collectionId;
    }

    public void setFilterCriteria(String aCriteria) {
        this.filterCriteria = aCriteria;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindCollectionIdsCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getRegionInfoName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("COLLECTION_ID", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.addOrderByCondition("COLLECTION_ID", table, Direction.ASC);
        result.appendCondition("ARCHIVE_DATE", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{":NULL"}, QueryElement.Predicate.AND, false);
        if (IAUtilities.hasContent(this.filterCriteria)) {
            Clause clause;
            ColumnReference column = PresentationFactory.getInstance().createBasicColumn("COLLECTION_ID", table, ColumnReference.DataType.String);
            column.applyFunction(ColumnReference.Function.UPPER);
            if (IAUtilities.isExactName(this.filterCriteria)) {
                clause = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, new Object[]{this.filterCriteria}, false);
            } else if (IAUtilities.containsDB2Wildcard(this.filterCriteria)) {
                String str = IAUtilities.escapeDB2Wildcards(this.filterCriteria, '\\');
                clause = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.LI, new Object[]{str}, false);
                clause.setEscape('\\');
            } else {
                clause = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.LI, new Object[]{this.filterCriteria}, false);
            }
            result.appendCondition((ConstraintElement)clause, QueryElement.Predicate.AND);
        }
        Debug.exit((Logger)logger, (String)FindCollectionIdsCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

