/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.CSect;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class FindCSectsCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindCSectsCommand.class.getPackage().getName());
    private Program program;
    private Resource dsn;

    public FindCSectsCommand(Program program, Resource dsn) {
        this.program = program;
        this.dsn = dsn;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)FindCSectsCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String csectName = resultSet.getString(1);
        CSect cSect = new CSect(csectName);
        cSect.setDsn(this.dsn);
        cSect.setProgram(this.program);
        Debug.exit((Logger)logger, (String)FindCSectsCommand.class.getName(), (String)"processRow");
        return cSect;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindCSectsCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getCSectInfoTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().addSelectionColumn("CSECT_NAME", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().setDistinct(true);
        result.appendCondition("PROGRAM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.program.getName()}, QueryElement.Predicate.AND, false);
        result.appendCondition("DSNAME", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.dsn.getName()}, QueryElement.Predicate.AND, false);
        result.addOrderByCondition("CSECT_NAME", table, Direction.ASC);
        Debug.exit((Logger)logger, (String)FindCSectsCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

