/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.CommandExecution;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.ResourceAndVerb;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Task;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.logging.Logger;

public class CommandExecutionForDistributedUOWCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CommandExecutionForDistributedUOWCommand.class.getPackage().getName());
    private String distributedUOW;

    public CommandExecutionForDistributedUOWCommand(String distributedUOW) {
        this.distributedUOW = distributedUOW;
        this.setAsync(false);
        this.setDescription("Command execution for " + distributedUOW);
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)CommandExecutionForDistributedUOWCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int i = 1;
        HashMap<String, String> results = new HashMap<String, String>();
        String[] stringArray = CommandExecutionForDistributedUOWCommand.getColumns();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str;
            String name = stringArray[n2];
            if ((str = resultSet.getString(i++)) == null) {
                str = "";
            }
            if (name.equals("CMD_TCB_CPUTIME_BEFORE") || name.equals("CMD_TCB_CPUTIME_AFTER")) {
                results.put(name, IAUtilities.getUserFriendlyTodMilliseconds(str.trim()));
            } else {
                results.put(name, str.trim());
            }
            ++n2;
        }
        String applid = (String)results.get("APPLID");
        String transID = (String)results.get("TRANSID");
        String taskID = (String)results.get("TASKID");
        String distributedUOW = (String)results.get("DISTRIBUTED_UOW");
        String programName = (String)results.get("PROGRAM");
        String functionName = (String)results.get("FUNCTION");
        String resourceType = (String)results.get("TYPE");
        String resourceName = (String)results.get("RESOURCE_NAME");
        String tcbMode = (String)results.get("TCBMODE");
        String prevTCBMode = (String)results.get("PREV_TCBMODE");
        Timestamp commandTime = Timestamp.valueOf((String)results.get("CMD_TIME_LOCAL"));
        String RESP = (String)results.get("CMD_EIBRESP");
        String RESP2 = (String)results.get("CMD_EIBRESP2");
        Region region = ResourceFactory.getSingleton().getRegion(applid);
        Program program = ResourceFactory.getSingleton().getProgram(programName);
        Transaction transaction = ResourceFactory.getSingleton().getTransaction(transID);
        Task task = ResourceFactory.getSingleton().getTask(transaction, taskID, applid);
        ResourceAndVerb resourceAndVerb = new ResourceAndVerb(resourceName, resourceType, functionName);
        CommandExecution commandExecution = new CommandExecution(region, task, transaction, distributedUOW, program, resourceAndVerb, tcbMode, prevTCBMode, commandTime, RESP, RESP2, results);
        Debug.exit((Logger)logger, (String)CommandExecutionForDistributedUOWCommand.class.getName(), (String)"processRow");
        return commandExecution;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)CommandExecutionForDistributedUOWCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getCommandFlowTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().setDistinct(true);
        String[] columnNames = CommandExecutionForDistributedUOWCommand.getColumns();
        if (columnNames != null) {
            int i = 0;
            while (i < columnNames.length) {
                result.getSelect().addSelectionColumn(columnNames[i], table, ColumnReference.DataType.String, null);
                ++i;
            }
        }
        result.appendCondition("DISTRIBUTED_UOW", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.distributedUOW}, QueryElement.Predicate.AND, false);
        result.appendCondition("PROGRAM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{"IGZCPCC"}, QueryElement.Predicate.AND, true);
        result.addOrderByCondition("CMD_TIME_LOCAL", table, Direction.ASC);
        result.addOrderByCondition("CMD_TCB_CPUTIME_BEFORE", table, Direction.ASC);
        Debug.exit((Logger)logger, (String)CommandExecutionForDistributedUOWCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }

    public static String[] getColumns() {
        return SQLDefinitions.CMDFLOW_ATTRIBUTES.getAdjustedAttributes();
    }
}

