/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.ia.commands.AtomRequest;
import com.ibm.cics.ia.model.AtomContentElement;
import com.ibm.cics.ia.model.AtomFeed;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.runtime.AtomController;
import com.ibm.cics.ia.sm.comm.IAtomConnection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CintPostRequest
extends AtomRequest {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CintPostRequest.class.getPackage().getName());
    private String applid;
    private String sysid;
    private String action;
    private AtomFeed feed;
    private IAtomConnection connection = null;
    private String taskName;
    private AtomContentElement requestElement = null;

    public CintPostRequest(String taskName, String applid, String sysid, String action, IConnection connection) {
        super(taskName);
        Debug.enter((Logger)logger, (String)CintPostRequest.class.getName(), (String)"CintPostRequest", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.applid = applid;
        this.sysid = sysid;
        this.action = action;
        this.connection = (IAtomConnection)connection;
        this.taskName = taskName;
        this.createRequestElement();
        Debug.exit((Logger)logger, (String)CintPostRequest.class.getName(), (String)"CintPostRequest");
    }

    public CintPostRequest(String taskName, AtomContentElement actionElement, IConnection connection) {
        this(taskName, actionElement.getAttribute("applid"), actionElement.getAttribute("sysid"), actionElement.getValue(), connection);
        this.requestElement = actionElement;
    }

    public void createRequestElement() {
        Debug.enter((Logger)logger, (String)CintPostRequest.class.getName(), (String)"createRequestElement", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.requestElement = new AtomContentElement();
        this.requestElement.setName("content");
        this.requestElement.setAttribute("type", "text/xml");
        AtomContentElement actionElement = new AtomContentElement();
        actionElement.setName("action");
        actionElement.setAttribute("applid", this.applid);
        actionElement.setAttribute("sysid", this.sysid);
        actionElement.setValue(this.action);
        this.requestElement.addElement(actionElement);
        Debug.exit((Logger)logger, (String)CintPostRequest.class.getName(), (String)"createRequestElement");
    }

    @Override
    public IStatus run(IProgressMonitor monitor) {
        Debug.enter((Logger)logger, (String)CintPostRequest.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (monitor != null) {
            monitor.beginTask(this.taskName, -1);
        }
        if (this.connection != null) {
            if (this.connection.isConnected()) {
                this.feed = null;
                HttpURLConnection urlConnection = null;
                int respCode = 0;
                String respMessage = "";
                String connectionID = this.connection.getConfiguration().getID();
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    String content = this.requestElement.toString();
                    baos.write(content.getBytes());
                    URL url = this.connection.getURL();
                    urlConnection = (HttpURLConnection)url.openConnection();
                    urlConnection = this.initHttpUrlConnection(url, this.connection, "POST");
                    urlConnection.setRequestProperty("Content-Type", "application/atom+xml");
                    urlConnection.setRequestProperty("Content-Length", Integer.toString(baos.size()));
                    urlConnection.setDoOutput(true);
                    OutputStreamWriter osw = new OutputStreamWriter(urlConnection.getOutputStream());
                    osw.write(content);
                    osw.flush();
                    InputStream is = urlConnection.getInputStream();
                    if (respCode >= 400) {
                        AtomController.getInstance().disconnect(this.connection, respCode, respMessage);
                    }
                    this.feed = AtomFeed.parse(is, connectionID);
                    if (this.feed != null && this.feed.atomEntries != null && this.feed.atomEntries.size() == 1 && this.feed.atomEntries.get((int)0).atomContent != null) {
                        CintCollector collector;
                        AtomContentElement element;
                        AtomContentElement messageElement = this.feed.atomEntries.get((int)0).atomContent.getContentElement().getFirstElementByName("message");
                        this.message = this.showMessage(messageElement);
                        if (this.feed.atomEntries.get((int)0).atomContent instanceof CintCollector && "".equals((element = (collector = (CintCollector)this.feed.atomEntries.get((int)0).atomContent).getContentElement().getFirstElementByName("region")).getAttribute("applid"))) {
                            url = this.connection.getConfiguration().getSecureHint() ? new URL("https", this.connection.getURL().getHost(), this.connection.getURL().getPort(), this.connection.getURL().getFile()) : new URL("http", this.connection.getURL().getHost(), this.connection.getURL().getPort(), this.connection.getURL().getFile());
                            urlConnection = this.initHttpUrlConnection(url, this.connection, "GET");
                            urlConnection.setRequestProperty("Content-Type", "application/atom+xml");
                            urlConnection.setRequestProperty("Content-Length", Integer.toString(baos.size()));
                            urlConnection.setDoOutput(true);
                            is = urlConnection.getInputStream();
                            if (respCode >= 400) {
                                AtomController.getInstance().disconnect(this.connection, respCode, respMessage);
                            }
                            this.feed = null;
                            this.feed = AtomFeed.parse(is, connectionID);
                            while (this.feed != null && this.feed.values.get("next") != null && this.feed.values.get("last") != null && !this.feed.values.get("next").endsWith("0ENDFEED")) {
                                url = new URL(this.feed.values.get("next"));
                                urlConnection = this.initHttpUrlConnection(url, this.connection, "GET");
                                is = urlConnection.getInputStream();
                                this.feed.parseNext(is);
                                respCode = urlConnection.getResponseCode();
                                respMessage = urlConnection.getResponseMessage();
                                if (respCode < 400) continue;
                                AtomController.getInstance().disconnect(this.connection, respCode, respMessage);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    try {
                        try {
                            respCode = urlConnection.getResponseCode();
                            respMessage = urlConnection.getResponseMessage();
                        }
                        catch (IOException iOException) {}
                    }
                    catch (Throwable throwable) {}
                    if (monitor != null) {
                        monitor.done();
                    }
                    AtomController.getInstance().disconnect(this.connection, ex, respCode, respMessage);
                    Debug.warning((Logger)logger, (String)CintPostRequest.class.getName(), (String)"run", (Throwable)ex, new HashMap());
                    Debug.exit((Logger)logger, (String)CintPostRequest.class.getName(), (String)"run");
                    return Status.OK_STATUS;
                }
            }
            if (monitor != null) {
                monitor.done();
            }
        }
        Debug.exit((Logger)logger, (String)CintPostRequest.class.getName(), (String)"run");
        return Status.OK_STATUS;
    }

    public AtomFeed getFeed() {
        return this.feed;
    }
}

