/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.ia.commands.AtomRequest;
import com.ibm.cics.ia.model.AtomContentElement;
import com.ibm.cics.ia.model.AtomFeed;
import com.ibm.cics.ia.runtime.AtomController;
import com.ibm.cics.ia.sm.comm.IAtomConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CintGetRequest
extends AtomRequest {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CintGetRequest.class.getPackage().getName());
    private String link;
    private String login;
    private String password;
    private AtomFeed feed;
    private IAtomConnection connection;
    private String taskName;

    public CintGetRequest(String taskName, IConnection connection) {
        super(taskName);
        this.connection = (IAtomConnection)connection;
        this.taskName = taskName;
    }

    @Override
    public synchronized IStatus run(IProgressMonitor monitor) {
        Debug.enter((Logger)logger, (String)CintGetRequest.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        monitor.beginTask(this.taskName, -1);
        if (this.connection == null) {
            return Status.CANCEL_STATUS;
        }
        this.feed = null;
        HttpURLConnection urlConnection = null;
        int respCode = 0;
        String respMessage = "";
        String connectionID = this.connection.getConfiguration().getID();
        if (this.connection.isConnected()) {
            try {
                URL url = this.connection.getURL();
                urlConnection = this.initHttpUrlConnection(url, this.connection, "GET");
                InputStream is = urlConnection.getInputStream();
                this.feed = AtomFeed.parse(is, connectionID);
                while (this.feed != null && this.feed.values.get("next") != null && this.feed.values.get("last") != null && !this.feed.values.get("next").endsWith("0ENDFEED")) {
                    url = new URL(this.feed.values.get("next"));
                    urlConnection = this.initHttpUrlConnection(url, this.connection, "GET");
                    is = urlConnection.getInputStream();
                    this.feed.parseNext(is);
                    respCode = urlConnection.getResponseCode();
                    respMessage = urlConnection.getResponseMessage();
                    if (respCode < 400) continue;
                    AtomController.getInstance().disconnect(this.connection, respCode, respMessage);
                }
                if (this.feed != null && this.feed.atomEntries != null && this.feed.atomEntries.size() > 0) {
                    AtomContentElement messageElement = this.feed.atomEntries.get((int)0).atomContent.getContentElement().getFirstElementByName("message");
                    this.showMessage(messageElement);
                }
            }
            catch (Exception ex) {
                try {
                    try {
                        respCode = urlConnection.getResponseCode();
                        respMessage = urlConnection.getResponseMessage();
                    }
                    catch (IOException iOException) {}
                }
                catch (Throwable throwable) {}
                if (monitor != null) {
                    monitor.done();
                }
                AtomController.getInstance().disconnect(this.connection, ex, respCode, respMessage);
                Debug.warning((Logger)logger, (String)CintGetRequest.class.getName(), (String)"run", (Throwable)ex, new HashMap());
                Debug.exit((Logger)logger, (String)CintGetRequest.class.getName(), (String)"run");
                return Status.OK_STATUS;
            }
        }
        monitor.done();
        Debug.exit((Logger)logger, (String)CintGetRequest.class.getName(), (String)"run");
        return Status.OK_STATUS;
    }

    public AtomFeed getFeed() {
        return this.feed;
    }
}

