/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.ia.commands.AtomRequest;
import com.ibm.cics.ia.model.AtomContentElement;
import com.ibm.cics.ia.model.AtomFeed;
import com.ibm.cics.ia.runtime.AtomController;
import com.ibm.cics.ia.sm.comm.IAtomConnection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CincPostRequest
extends AtomRequest {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CincPostRequest.class.getPackage().getName());
    private String action;
    private String userId;
    private String requestSuffix;
    private AtomFeed feed;
    private IAtomConnection connection = null;
    private String taskName;
    private AtomContentElement requestElement = null;

    public CincPostRequest(String taskName, String action, String userId, IConnection connection) {
        super(taskName);
        Debug.enter((Logger)logger, (String)CincPostRequest.class.getName(), (String)"CincPostRequest", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.action = action;
        this.connection = (IAtomConnection)connection;
        this.taskName = taskName;
        this.userId = userId;
        this.createRequestElement();
        Debug.exit((Logger)logger, (String)CincPostRequest.class.getName(), (String)"CincPostRequest");
    }

    public CincPostRequest(String taskName, AtomContentElement requestElement, String requestSuffix, IConnection connection) {
        super(taskName);
        Debug.enter((Logger)logger, (String)CincPostRequest.class.getName(), (String)"CincPostRequest", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.connection = (IAtomConnection)connection;
        this.taskName = taskName;
        this.requestElement = requestElement;
        this.requestSuffix = requestSuffix;
        Debug.exit((Logger)logger, (String)CincPostRequest.class.getName(), (String)"CincPostRequest");
    }

    public void createRequestElement() {
        Debug.enter((Logger)logger, (String)CincPostRequest.class.getName(), (String)"createRequestElement", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.requestElement = new AtomContentElement();
        this.requestElement.setName("content");
        this.requestElement.setAttribute("type", "text/xml");
        AtomContentElement actionElement = new AtomContentElement();
        actionElement.setName("cincaction");
        actionElement.setValue(this.action);
        if (this.userId != null) {
            actionElement.setAttribute("usersrc", this.userId);
        }
        this.requestElement.addElement(actionElement);
        this.requestSuffix = "?cinc=y";
        if ("ADMINDTL".equals(this.action)) {
            this.requestSuffix = "?cinc=a";
        }
        Debug.exit((Logger)logger, (String)CincPostRequest.class.getName(), (String)"createRequestElement");
    }

    @Override
    public IStatus run(IProgressMonitor monitor) {
        Debug.enter((Logger)logger, (String)CincPostRequest.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (monitor != null) {
            monitor.beginTask(this.taskName, -1);
        }
        if (this.connection != null) {
            this.feed = null;
            HttpURLConnection urlConnection = null;
            int respCode = 0;
            String respMessage = "";
            String connectionID = this.connection.getConfiguration().getID();
            if (this.connection.isConnected()) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    String content = this.requestElement.toString();
                    baos.write(content.getBytes());
                    URL url = this.connection.getURL();
                    url = this.connection.getConfiguration().getSecureHint() ? new URL("https", url.getHost(), url.getPort(), String.valueOf(url.getFile()) + this.requestSuffix) : new URL("http", url.getHost(), url.getPort(), String.valueOf(url.getFile()) + this.requestSuffix);
                    urlConnection = this.initHttpUrlConnection(url, this.connection, "POST");
                    urlConnection.setRequestProperty("Content-Type", "application/atom+xml");
                    urlConnection.setRequestProperty("Content-Length", Integer.toString(baos.size()));
                    urlConnection.setDoOutput(true);
                    OutputStreamWriter osw = new OutputStreamWriter(urlConnection.getOutputStream());
                    osw.write(content);
                    osw.flush();
                    InputStream is = urlConnection.getInputStream();
                    if (respCode >= 400) {
                        AtomController.getInstance().disconnect(this.connection, respCode, respMessage);
                    }
                    this.feed = AtomFeed.parse(is, connectionID);
                    if (this.feed != null && this.feed.atomEntries.size() == 1) {
                        AtomContentElement contentElement = this.feed.atomEntries.get((int)0).atomContent.getContentElement();
                        if (!"STAT".equals(this.action)) {
                            AtomContentElement messageElement = contentElement.getFirstElementByName("message");
                            this.message = this.showMessage(messageElement);
                        }
                        if (("START".equals(this.action) || "STOP".equals(this.action)) && contentElement.getFirstElementByName("group") == null) {
                            this.connection.getURL();
                            url = this.connection.getConfiguration().getSecureHint() ? new URL("https", url.getHost(), url.getPort(), String.valueOf(url.getFile()) + "?cinc=y") : new URL("http", url.getHost(), url.getPort(), String.valueOf(url.getFile()) + "?cinc=y");
                            urlConnection = this.initHttpUrlConnection(url, this.connection, "GET");
                            is = urlConnection.getInputStream();
                            if (respCode >= 400) {
                                AtomController.getInstance().disconnect(this.connection, respCode, respMessage);
                            }
                            this.feed = AtomFeed.parse(is, connectionID);
                            connectionID = this.connection.getConfiguration().getID();
                        }
                    }
                }
                catch (Exception ex) {
                    try {
                        try {
                            respCode = urlConnection.getResponseCode();
                            respMessage = urlConnection.getResponseMessage();
                        }
                        catch (IOException iOException) {}
                    }
                    catch (Throwable throwable) {}
                    if (monitor != null) {
                        monitor.done();
                    }
                    AtomController.getInstance().disconnect(this.connection, ex, respCode, respMessage);
                    Debug.warning((Logger)logger, (String)CincPostRequest.class.getName(), (String)"run", (Throwable)ex, new HashMap());
                    Debug.exit((Logger)logger, (String)CincPostRequest.class.getName(), (String)"run");
                    return Status.OK_STATUS;
                }
            }
            if (monitor != null) {
                monitor.done();
            }
        }
        Debug.exit((Logger)logger, (String)CincPostRequest.class.getName(), (String)"run");
        return Status.OK_STATUS;
    }

    public AtomFeed getFeed() {
        return this.feed;
    }
}

