/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.ia.model.AtomContentElement;
import com.ibm.cics.ia.model.AtomDefinitions;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.Messages;
import com.ibm.cics.ia.sm.comm.IAtomConnection;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class AtomRequest
extends Job {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String message = "";
    private static final Logger logger = Logger.getLogger(AtomRequest.class.getPackage().getName());

    public AtomRequest(String name) {
        super(name);
    }

    protected IStatus run(IProgressMonitor monitor) {
        return null;
    }

    public HttpURLConnection initHttpUrlConnection(URL url, IAtomConnection connection, String requestMethod) throws IOException {
        Debug.enter((Logger)logger, (String)AtomRequest.class.getName(), (String)"initHttpUrlConnection", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setDoInput(true);
        urlConnection.setRequestMethod(requestMethod);
        urlConnection.setRequestProperty("Authorization", "Basic " + connection.getAuthString());
        urlConnection.setReadTimeout(30000);
        urlConnection.setConnectTimeout(30000);
        Debug.exit((Logger)logger, (String)AtomRequest.class.getName(), (String)"initHttpUrlConnection");
        return urlConnection;
    }

    public String showMessage(AtomContentElement messageElement) {
        Debug.enter((Logger)logger, (String)AtomRequest.class.getName(), (String)"showMessage", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String message = "";
        if (messageElement != null) {
            String messageNum = messageElement.getAttribute("msgnum");
            AtomContentElement params = messageElement.getFirstElementByName("params");
            if (params != null) {
                String messageCode;
                List<AtomContentElement> paramList = params.getChildElementsByName("param");
                ArrayList<String> args = new ArrayList<String>();
                for (AtomContentElement atomContentElement : paramList) {
                    String value = atomContentElement.getValue();
                    if (value == null || "".equals(value)) continue;
                    args.add(value);
                }
                if (args.size() > 0) {
                    messageCode = "CICSIA.Collector." + messageNum;
                    message = String.valueOf(messageNum) + ":" + " " + MessageFormat.format(Messages.getString(messageCode), args.toArray());
                } else {
                    messageCode = "CICSIA.Collector." + messageNum;
                    message = String.valueOf(messageNum) + ":" + " " + Messages.getString(messageCode);
                }
                if (AtomDefinitions.WARNING_MESSAGES.contains(messageNum) || AtomDefinitions.ERROR_MESSAGES.contains(messageNum) || AtomDefinitions.SEVERE_MESSAGES.contains(messageNum)) {
                    ViewHelper.setDeferredStatusErrorMessage((String)message);
                    IAPlugin.getDefault().logError(message, null);
                } else if (AtomDefinitions.INFO_MESSAGES.contains(messageNum)) {
                    ViewHelper.setDeferredStatusInformationMessage((String)message);
                } else {
                    ViewHelper.setDeferredStatus((IStatus)Status.CANCEL_STATUS);
                }
            }
        }
        Debug.exit((Logger)logger, (String)AtomRequest.class.getName(), (String)"showMessage");
        return message;
    }

    public String getMessage() {
        return this.message;
    }
}

