/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.dbfunc.command.StoredProcedureCommand;
import com.ibm.cics.dbfunc.command.StoredProcedureDefinition;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.model.AffGroup;
import com.ibm.cics.ia.model.AffinityType;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPAFF;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Logger;

public class AffinityGroupsReportCommand
extends StoredProcedureCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AffinityGroupsReportCommand.class.getPackage().getName());
    private Region region;
    private AffinityType affinityType;

    public AffinityGroupsReportCommand(Region region, AffinityType affinityType) {
        this.region = region;
        this.affinityType = affinityType;
        this.setCategory("com.ibm.cics.ia.connection.db2");
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)AffinityGroupsReportCommand.class.getName(), (String)"processRow");
        HashMap<String, String> values = new HashMap<String, String>();
        Object tranGroup = null;
        String applid = resultSet.getString(1);
        String trangroup = resultSet.getString(2);
        String affType = resultSet.getString(3);
        String groupType = resultSet.getString(4);
        String affinity = resultSet.getString(5);
        String affWorsened = resultSet.getString(6);
        String lifetime = resultSet.getString(7);
        String lifeWorsened = resultSet.getString(8);
        String recovery = resultSet.getString(9);
        String resource = resultSet.getString(10);
        String affGrpType = resultSet.getString(12);
        String affGrpTranCount = resultSet.getString(13);
        String affGrpProgCount = resultSet.getString(14);
        String affGrpBuild = resultSet.getString(15);
        values.put("APPLID", applid == null ? "" : applid.trim());
        values.put("TRANGROUP", trangroup == null ? "" : trangroup.trim());
        values.put("AFFTYPE", affType == null ? "" : affType.trim());
        values.put("GROUPTYPE", groupType == null ? "" : groupType.trim());
        values.put("AFFINITY", affinity == null ? "" : affinity.trim());
        values.put("AFFWORSENED", affWorsened == null ? "" : affWorsened.trim());
        values.put("LIFETIME", lifetime == null ? "" : lifetime.trim());
        values.put("LIFEWORSENED", lifeWorsened == null ? "" : lifeWorsened.trim());
        values.put("RECOVERY", recovery == null ? "" : recovery.trim());
        values.put("RESOURCE", resource == null ? "" : resource.trim());
        values.put("TYPE", affGrpType == null ? "" : affGrpType.trim());
        values.put("TRANCOUNT", affGrpTranCount == null ? "" : affGrpTranCount.trim());
        values.put("PROGCOUNT", affGrpProgCount == null ? "" : affGrpProgCount.trim());
        values.put("BUILD", affGrpBuild == null ? "" : affGrpBuild.trim());
        if (trangroup != null) {
            AffGroup affGroup = new AffGroup(trangroup, values);
            Debug.exit((Logger)logger, (String)AffinityGroupsReportCommand.class.getName(), (String)"processRow");
            return affGroup;
        }
        Debug.exit((Logger)logger, (String)AffinityGroupsReportCommand.class.getName(), (String)"processRow");
        return null;
    }

    public void setRegion(Region aRegion) {
        this.region = aRegion;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)AffinityGroupsReportCommand.class.getName(), (String)"getSelectionObject");
        Selection result = null;
        if (DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2").isProcedureAvailable((StoredProcedureDefinition)new ProcedureCIUSPAFF())) {
            ProcedureCIUSPAFF sp = new ProcedureCIUSPAFF();
            result = (Selection)sp.getSelectionObject("RGN", this.region.getName(), String.valueOf(this.affinityType.toString()) + "%%%%%%%%");
        }
        Debug.exit((Logger)logger, (String)AffinityGroupsReportCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

