/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.dbfunc.command.StoredProcedureCommand;
import com.ibm.cics.dbfunc.command.StoredProcedureDefinition;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.model.AffCommand;
import com.ibm.cics.ia.model.AffGroup;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPAFF;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Logger;

public class AffinityCommandsReportCommand
extends StoredProcedureCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AffinityCommandsReportCommand.class.getPackage().getName());
    private AffGroup affGroup;

    public AffinityCommandsReportCommand(AffGroup anAffGroup) {
        this.affGroup = anAffGroup;
        this.setAsync(false);
        this.setCategory("com.ibm.cics.ia.connection.db2");
    }

    public AffinityCommandsReportCommand() {
        this(null);
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)AffinityCommandsReportCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap<String, String> values = new HashMap<String, String>();
        String applid = resultSet.getString(1);
        String transid = resultSet.getString(2);
        String program = resultSet.getString(3);
        String offset = resultSet.getString(4);
        String affCmdCommand = resultSet.getString(5);
        String affCmdResType = resultSet.getString(6);
        String affCmdAffGroup = resultSet.getString(7);
        String affCmdTerminal = resultSet.getString(8);
        String affCmdBTS = resultSet.getString(9);
        String affCmdLINK3270 = resultSet.getString(10);
        String affCmdUsage = resultSet.getString(11);
        values.put("APPLID", applid == null ? "" : applid.trim());
        values.put("TRANSID", transid == null ? "" : transid.trim());
        values.put("PROGRAM", program == null ? "" : program.trim());
        values.put("OFFSET", offset == null ? "" : offset.trim());
        values.put("COMMAND", affCmdCommand == null ? "" : affCmdCommand.trim());
        values.put("RESTYPE", affCmdResType == null ? "" : affCmdResType.trim());
        values.put("AFFGROUP", affCmdAffGroup == null ? "" : affCmdAffGroup.trim());
        values.put("TERMINAL", affCmdTerminal == null ? "" : affCmdTerminal.trim());
        values.put("BTS", affCmdBTS == null ? "" : affCmdBTS.trim());
        values.put("LINK3270", affCmdLINK3270 == null ? "" : affCmdLINK3270.trim());
        values.put("USAGE", affCmdUsage == null ? "" : affCmdUsage.trim());
        AffCommand affCommand = new AffCommand(this.affGroup, values);
        Debug.exit((Logger)logger, (String)AffinityCommandsReportCommand.class.getName(), (String)"processRow");
        return affCommand;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)AffinityCommandsReportCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Selection result = null;
        if (DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2").isProcedureAvailable((StoredProcedureDefinition)new ProcedureCIUSPAFF())) {
            ProcedureCIUSPAFF sp = new ProcedureCIUSPAFF();
            result = (Selection)sp.getSelectionObject("GRP", this.affGroup.getRegion().getName(), this.affGroup.getTranGroup());
        }
        Debug.exit((Logger)logger, (String)AffinityCommandsReportCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

