/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.AbstractFindCICSObjectType;
import com.ibm.cics.ia.query.ApplicationSubQuery;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.logging.Logger;

public abstract class AbstractFindCICSObjectsForApplication
extends AbstractFindCICSObjectType {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AbstractFindCICSObjectsForApplication.class.getPackage().getName());
    protected String criteria;
    protected String resourceName;

    @Override
    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)AbstractFindCICSObjectsForApplication.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Selection result = null;
        String table = IAUtilities.getResourcesTableName();
        result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("OBJECT", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        if (IAUtilities.hasContent(collectionId)) {
            result.appendCondition("COLLECTION_ID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        result.appendCondition("TYPE", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.getResourceType()}, QueryElement.Predicate.AND, false);
        Selection nestedSubQuery = new ApplicationSubQuery(this.getResourceType(), this.criteria).getPresentation().getSelection();
        nestedSubQuery.setOrderBy(null);
        result.appendCondition("OBJECT", table, ColumnReference.DataType.String, Comparator.IN, new Object[]{nestedSubQuery}, QueryElement.Predicate.AND, false);
        if (IAUtilities.hasContent(this.resourceName) && this.resourceName.length() > 0) {
            if (IAUtilities.isExactName(this.resourceName)) {
                result.appendCondition("OBJECT", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resourceName}, QueryElement.Predicate.AND, false);
            } else {
                result.appendCondition("OBJECT", table, ColumnReference.DataType.String, Comparator.LI, new Object[]{this.resourceName}, QueryElement.Predicate.AND, false);
            }
        }
        Debug.exit((Logger)logger, (String)AbstractFindCICSObjectsForApplication.class.getName(), (String)"getSelectionObject");
        return result;
    }

    @Override
    public void setCriteriaName(String criteria) {
        this.criteria = criteria;
    }

    @Override
    public void setResourceName(String aResourceName) {
        Debug.enter((Logger)logger, (String)AbstractFindCICSObjectsForApplication.class.getName(), (String)"setResourceName", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (IAUtilities.hasContent(aResourceName) && aResourceName.length() > 0) {
            this.resourceName = aResourceName;
        }
        Debug.exit((Logger)logger, (String)AbstractFindCICSObjectsForApplication.class.getName(), (String)"setResourceName");
    }

    @Override
    protected abstract String getResourceType();

    @Override
    protected abstract int getResourceNameSize();
}

