/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.wizards;

import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.pa.ui.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class SampleNewCSVPage
extends WizardPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text containerText;
    private Text fileText;
    private static final String pageName = "pasamplewizardPage";
    private ISelection selection;

    public SampleNewCSVPage(ISelection selection) {
        super(pageName);
        this.setTitle(Messages.getString("SampleNewCSVPage.sample"));
        this.setDescription(Messages.getString("SampleNewCSVPage.description"));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(Messages.getString("SampleNewCSVPage.container"));
        this.containerText = new Text(container, 2052);
        TextInput.setAccessibleLabel((Text)this.containerText, (Label)label);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SampleNewCSVPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(Messages.getString("SampleNewCSVPage.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SampleNewCSVPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.getString("SampleNewCSVPage.file"));
        this.fileText = new Text(container, 2052);
        TextInput.setAccessibleLabel((Text)this.fileText, (Label)label);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SampleNewCSVPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        this.fileText.setText("sample.csv");
    }

    void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.getString("SampleNewCSVPage.select"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    void dialogChanged() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus(Messages.getString("SampleNewCSVPage.afile"));
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus(Messages.getString("SampleNewCSVPage.mustexist"));
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus(Messages.getString("SampleNewCSVPage.writeable"));
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(Messages.getString("SampleNewCSVPage.specified"));
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus(Messages.getString("SampleNewCSVPage.valid"));
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("csv")) {
            this.updateStatus(Messages.getString("SampleNewCSVPage.extension"));
            return;
        }
        IFile file = ((IContainer)container).getFile((IPath)new Path(fileName));
        if (file.exists()) {
            this.updateStatus(Messages.getString("SampleNewCSVPage.fileexists"));
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }
}

